import vobject
import urllib
from datetime import date

def workshop_name():
    """
    Reading the ical from fossee.in
    and generating a option field for 
    selecting particular workshop.
    Disabling the registration when 
    number of days are less then 5 and
    enabling registration when workshop 
    is within 30 days.
    """
    eventList = []
    #disable this when we are deploying it!
    proxies = {'http': 'http://fossee:Python321@10.101.1.1:80'}
    eventPage = urllib.urlopen('http://fossee.in/event/ical', proxies=proxies).read()    
    parsedCal = vobject.readOne(eventPage)    
    for event in parsedCal.components():
        eventDate = event.dtstart.value.date()
	daysLeft = eventDate - date.today()
	if daysLeft.days > 3 and daysLeft.days < 31:
            eventList += (tuple((event.summary.value,event.summary.value)),)    
    return tuple(eventList)

if __name__ == '__main__':
    print workshop_name()                             


