from django.db import models
import workshops 

# Create your models here.

class Participant(models.Model):	
    CATEGORY_CHOICES = (
    ('Student','Student'),
    ('College Faculty/Teacher','College Faculty/Teacher'),
    ('Others','Others'),
    )
    eventList = workshops.workshop_name()
    #workshops.workshop_name(eventList)
    name = models.CharField(max_length = 50)
    email = models.EmailField()		
    phonenumber = models.CharField(max_length=15, verbose_name='Phone Number')
    discipline = models.CharField(max_length=100, help_text='(ex: Mechanical/Chemical Engg)')
    category = models.CharField(max_length = 80, choices=CATEGORY_CHOICES)	
    affiliation = models.CharField(max_length = 256, verbose_name='Affiliated to:(Name of College/Company)')    
    workshop = models.CharField(max_length = 256,choices=eventList)
    tools = models.TextField(max_length = 200, blank=True, verbose_name='Tools you are using',help_text='(C, C++, Matlab etc.)')
    #accommodation = models.BooleanField(verbose_name='Do you require accommodation?')
