#can add features like: supporting files with specified extensions, making edit box of content better etc.
from django.http import HttpResponse
from django.template import Context, Template
from django.shortcuts import render_to_response
from django.contrib.auth.decorators import login_required

from forms import ParticipantForm
from models import Participant

def register_user(request, template_name='index.html'):
    if request.method == 'POST':
        form = ParticipantForm(request.POST, request.FILES)		
        if form.is_valid():            
            form.save()	   
            return render_to_response(template_name, {'form': form, 'value': False,})
        else:
            return render_to_response(template_name, {'form': form, 'value': True,})
    return render_to_response(template_name,
			  {'form': ParticipantForm(), 'value': True})

#@login_required
def view_registrants(request, template_name='registrants.html'):
    """
    View to return list of registered participants
    """
    ##wow what a one liner
    poc = dict([line.strip().split('|') for line in open('upload/poc')])        
    if not request.user.is_authenticated():
        return HttpResponse("You can't view these details.")
    context_registrants = []

    registrations = Participant.objects.all()
    for registrant in registrations:
        if poc[request.user.username] == registrant.workshop:
            context_registrants.append({
                'registrant':registrant,
                })
    context = {
        'registrants':context_registrants,
        }
    return render_to_response(template_name, context)
    
