from django import forms

from ws_app.feedback.models import Feedback

class FeedbackForm(forms.ModelForm):
    """ A form to collect the feedback.
    """

    class Meta:
        model = Feedback
        exclude = [ 'event', 'day']

    def clean_comments(self):
        comments = self.cleaned_data['comments']
        return comments.strip()
