from django.shortcuts import render_to_response, redirect

from workshop.reg.models import Event

from workshop.feedback.models import Feedback
from workshop.feedback.forms import FeedbackForm

from django.http import HttpResponse

def submit_feedback(request, event_key):
    """ see if the ip address has already submitted a feedback.
    if not, collect the feedback.
    """

    try:
        event = Event.objects.get(key=event_key)
    except Event.DoesNotExist:
        return redirect('/reg')

    if event.feedback_status == "0":
        return redirect('/reg')

    user_ip = request.META["REMOTE_ADDR"]
    try:
        old_feedback = Feedback.objects.get(day=event.feedback_status, user_ip=user_ip)
        return render_to_response('feedback.html', {'submitted':True})
    except:
        new_feedback = Feedback(event=event, user_ip=user_ip, day=event.feedback_status)
    
    if request.method == "POST":
        form = FeedbackForm(request.POST)
        if form.is_valid():
            data = form.cleaned_data
            new_feedback.topics = data['topics']  
            new_feedback.depth = data['depth']
            new_feedback.methodology = data['methodology']
            new_feedback.pace = data['pace']
            new_feedback.applicability = data['applicability']
            new_feedback.problems = data['problems']
            new_feedback.exercises = data['exercises']
            new_feedback.comments = data['comments']
            new_feedback.save()
            return render_to_response('feedback.html', {'submitted':True})
        else:
            return render_to_response('feedback.html',{'form':form})
    else:
        form = FeedbackForm()
        return render_to_response('feedback.html',{'form':form})

def list_feedbacks(request, event_key):
    """ print a list of all the feedbacks collected.
    """

    feeds = Feedback.objects.all()
    return render_to_response('list_feedbacks.html',{'feeds':feeds})
