from django.db import models
from django.contrib.auth.models import User

from workshop.reg.models import Event

TOPICS_CHOICES = (('1', 'Very relevant'),
                  ('2', 'Relevant'),
                  ('3', 'Somewhat relevant'),
                  ('4', 'Not relevant'))

DEPTH_CHOICES = (('1', 'Too detailed'),
                 ('2', 'Detailed'),
                 ('3', 'Not enough detail'),
                 ('4', 'Poor detail'))

METHODOLOGY_CHOICES = (('1', 'Extremely effective'),
                       ('2', 'Effective'),
                       ('3', 'Not very effective'),
                       ('4', 'Ineffective'))

PACE_CHOICES = (('1', 'Too fast'),
                ('2', 'Fast'),
                ('3', 'Just right'),
                ('4', 'Slow'),
                ('5', 'Too slow'))

APPLICABILITY_CHOICES = (('1', 'I can use most of it immediately'),
                         ('2', 'I can use it somewhat immediately'),
                         ('3', 'I cannot use it immediately'),
                         ('4', 'I might never use it'))

PROBLEMS_CHOICES = (('1', 'Very intersting'),
                    ('2', 'Interesting'),
                    ('3', 'Somewhat interesting'),
                    ('4', 'Not interesting'))

EXERCISES_CHOICES = (('1', 'Very instructive'),
                     ('2', 'Instructive'),
                     ('3', 'Somewhat instructive'),
                     ('4', 'Not instructive'))

class Feedback(models.Model):
    """ A table to hold the feedbacks.
    """

    user_ip = models.CharField(max_length=15)
    event = models.ForeignKey(Event)

    range_of_topics = models.CharField(max_length=1, choices=TOPICS_CHOICES,
                                       verbose_name="Range of topics covered", blank=True)
    depth_of_coverage = models.CharField(max_length=1, choices=DEPTH_CHOICES, blank=True)
    effectiveness_of_methodology = models.CharField(max_length=1, choices=METHODOLOGY_CHOICES, blank=True)
    pace_of_coverage = models.CharField(max_length=1, choices=PACE_CHOICES, blank=True)
    applicability = models.CharField(max_length=1, choices=APPLICABILITY_CHOICES, blank=True)
    choice_of_problems = models.CharField(max_length=1, choices=PROBLEMS_CHOICES, blank=True)
    chocice_of_exercises = models.CharField(max_length=1, choices=EXERCISES_CHOICES, blank=True)
    comments = models.TextField(verbose_name="General comments", blank=True)

