from django.conf.urls.defaults import *

from ws_app.reg import views as reg_views

urlpatterns = patterns('',
    (r'^$', reg_views.homepage),
    (r'^login/$', reg_views.user_login),
    (r'^logout/$', reg_views.user_logout),
    (r'^register/(\w*)$', reg_views.user_register),
    (r'^account_created/$', reg_views.account_created),                       
    (r'^resend_activation/$', reg_views.resend_activation),
    (r'^activate/(\w+)/$', reg_views.account_activate),
    (r'^profile/view/$', reg_views.view_profile),
    (r'^profile/edit/$', reg_views.edit_profile),                       
    (r'^password_reset/$', reg_views.reset_password),
    (r'^password_change/$', reg_views.change_password),
    (r'^event/create/$', reg_views.create_event),
    (r'^event/list/$', reg_views.list_events),                       
    (r'^event/view/(\w+)/$', reg_views.view_event),
    (r'^event/register/(\w+)/$', reg_views.register_for_event),
    (r'^event/attendees/(\w+)/$', reg_views.list_attendees),                       
    (r'^event/feedback/open/(\w+)/$', reg_views.open_feedback),
    (r'^event/feedback/close/(\w+)/$', reg_views.close_feedback),
    (r'^event/registration/open/(\w+)/$', reg_views.open_registration),
    (r'^event/registration/close/(\w+)/$', reg_views.close_registration),
)
