#!/usr/bin/python

from django.contrib.auth.models import User

from django.db import IntegrityError

from workshop.reg.models import Profile, Event
from workshop.reg.utils import gen_key

def create_user(email, password, firstname="", lastname="", gender="M", profession="S", affiliated_to="", interests="" ):
    """ create a user with random username and set the password.
    """

    while True:
        try:
            username = gen_key(8)
            user = User.objects.get(username=username)
        except User.DoesNotExist:
            break
    new_user = User.objects.create_user(username, email, password)
    new_user.firstname = firstname
    new_user.lastname = lastname
    new_user.is_active = False
    new_user.save()

    new_profile = Profile(user=new_user)
    new_profile.gender = gender
    new_profile.profession = profession
    new_profile.affiliated_to = affiliated_to
    new_profile.interests = interests

    while True:
        try:
            new_profile.activation_key = gen_key(30)
            new_profile.save()
            return new_user
        except IntegrityError:
            pass

def create_event(title, description, start_date, stop_date, created_by=None):
    """ make an event and save it.
    """

    new_event = Event()
    new_event.title = title
    new_event.description = description
    new_event.start_date = start_date
    new_event.stop_date = stop_date
    new_event.save()
    if created_by:
        new_event.organizers.add(created_by)

    while True:
        try:
            new_event.key = gen_key(10)
            new_event.save()
            return new_event
        except IntegrityError:
            pass

def activate_user(user):
    """ mark the is_active flag as true.
    """

    user.is_active = True
    user.save()
    return user

def reset_password(user):
    """ get a key and set it as password.
    for now, print the key.
    later on add the send mail function.
    """

    new_password = gen_key(10)
    user.set_password(new_password)
    user.save()
    print "The new password is", new_password
    return new_password

def change_password(user, new_password):
    """ for now just set the password and be done with it.
    later on, if we want to do something else also then we can add them here.
    """

    user.set_password(new_password)
    user.save()


