from django.db import models
from django.contrib.auth.models import User

GENDER_CHOICES = (('M', "Male"),
                  ('F', 'Female'))

PROFESSION_CHOICES = (('S', 'Student'),
                      ('F', 'Faculty'),
                      ('P', 'Professional'))

FEEDBACK_CHOICES = (('0', 'Closed'),
                    ('1', 'Day 1 Open'),
                    ('2', 'Day 2 Open'),
                   )

QUIZ_CHOICES = (('00', 'Closed'),
                ('11', 'Day1 Quiz1 Open'),
                ('12', 'Day1 Quiz2 Open'),
                ('21', 'Day2 Quiz1 Open'),
               )

class Profile(models.Model):
    """ A model to hold extra information about the user.
    """

    user = models.ForeignKey(User, unique=True)
    gender = models.CharField(max_length=1, choices=GENDER_CHOICES)
    profession = models.CharField(max_length=1, choices=PROFESSION_CHOICES)
    affiliated_to = models.CharField(max_length=100, verbose_name="College/Company")
    interests = models.CharField(max_length=100, verbose_name="Fields of Interest", 
                                 help_text="Ex: Python, Image Processing, Bio Informatics etc.")

    activation_key = models.CharField(max_length=30, unique=True)

class Event(models.Model):
    """ A model for the workshop information.
    """

    key = models.CharField(max_length=10, unique=True)

    title = models.CharField(max_length=100)
    description = models.TextField()
    start_date = models.DateField(verbose_name="Start Date")
    stop_date = models.DateField(verbose_name="End Date")
    attendees = models.ManyToManyField(User, related_name="%(class)s_attendees")
    organizers = models.ManyToManyField(User, related_name="%(class)s_organizers")
    
    registration_is_open = models.BooleanField(default=False)
    feedback_status = models.CharField(max_length=1, choices=FEEDBACK_CHOICES, default='0')
    quiz_status = models.CharField(max_length=2, choices=QUIZ_CHOICES, default='00')

    def __unicode__(self):

        return self.title
