#can add features like: supporting files with specified extensions, making edit box of content better etc.
from django.http import HttpResponse
from django.template import Context, Template
from django.shortcuts import render_to_response

from forms import ParticipantForm
from models import Participant


#function to read the upoaded file and store it
def handle_uploaded_file(f):
    destination = open(f.name, 'wb+')
    for chunk in f.chunks():
        destination.write(chunk)
    destination.close()

#view to handle uploaded file, showing content of file, and option of uploading a file
def upload_file(request, template_name='index.html'):
    if request.method == 'POST':
        form = ParticipantForm(request.POST, request.FILES)		
        if form.is_valid():
            #handle_uploaded_file(request.FILES['file'])
            form.save()	   
            return render_to_response(template_name, {'form': form, 'value': False,})
        else:
            return render_to_response(template_name, {'form': form, 'value': True,})
    return render_to_response(template_name,
			  {'form': ParticipantForm(), 'value': True})
			  
def submission(request, template_name='submission.html'):
    """View to return the submitted videos
    """
    context_participants = []

    participants = Participant.objects.all()
    for participant in participants:
      context_participants.append({
          'participant': participant,
          'file_name': str(participant.filename).split('/')[-1],
          })
      
    context = {
        'participants': context_participants,
        }

    return render_to_response(template_name, context)
