from django.db import models

# Create your models here.

class Participant(models.Model):
	LANGUAGE_CHOICES = (
    ('Assamese', 'Assamese/Axomiya'),
    ('Bengali', 'Bengali'),
    ('Bhojpuri', 'Bhojpuri'),
    ('Bodo', 'Bodo'),
    ('Dogri', 'Dogri'),
    ('English', 'English'),
    ('Gujarati', 'Gujarati'),
    ('Hindi', 'Hindi'),
    ('Kannada', 'Kannada'),
    ('Kashmiri', 'Kashmiri'),
    ('Konkani', 'Konkani'),
    ('Maithili', 'Maithili'),
    ('Malayalam', 'Malayalam'),
    ('Manipuri', 'Manipuri'),
    ('Marathi', 'Marathi'),
    ('Nepali', 'Nepali'),
    ('Oriya', 'Oriya'),
    ('Punjabi', 'Punjabi'),
    ('Sanskrit', 'Sanskrit'),
    ('Santali', 'Santali'),
    ('Sindhi', 'Sindhi'),
    ('Tamil', 'Tamil'),
    ('Telugu', 'Telugu'),
    ('Tulu', 'Tulu'),
    ('Urdu', 'Urdu'),
    ('Other', 'Other')
    )

	CATEGORY_CHOICES = (
		('Student at IIT','Student at IIT'),
        ('Staff and family','Staff and family'),
        ('Faculty and family','Faculty and family'),
        ('Others','Others'),
	    )

	name = models.CharField(max_length = 50)
	email = models.EmailField()
	filename = models.FileField(upload_to='videos/%Y/%m/%d')
	language = models.CharField(max_length = 20, choices=LANGUAGE_CHOICES)
	other_lang = models.CharField(max_length = 256, 
															  verbose_name='If Others, specify',
															  blank=True, null=True)
	phonenumber = models.CharField(max_length=15)
	age = models.IntegerField(max_length=3)
	category = models.CharField(max_length = 80, choices=CATEGORY_CHOICES)	
