from django import forms

from spoken_tut.upload.models import Participant


class ParticipantForm(forms.ModelForm):
  def clean_other_lang(self):
    """Cleaner for validating Other language field.
    """
    cleaned_data = self.cleaned_data
    lang = cleaned_data.get('language')
    other_lang = cleaned_data.get('other_lang')
    if lang == 'Other' and not other_lang:
      raise forms.ValidationError('Please fill in the other language field.')

    return other_lang

  def clean(self):
    """Form cleaner for accepting the terms and conditions.
    """

    data = self.data
    accept = data.get('accept')
    
    if not accept:
      raise forms.ValidationError(
          'You need to accept the terms and condition for uploading the data.')

    return self.cleaned_data

  class Meta:
    model = Participant
