# UploadFormat Parser -- test version
#                                       -- ideamonk

class Submission():
  """
  A helper class for bulk uploads. It parses the given chunk of bulk
  upload and tries to submit them to PyKata
  """
  def __init__(self, bulk_text):
    # initialize everything as default/blank as some things might not be
    # present in submission
    self.data_dict = dict()
    self.bulk_text = bulk_text
    self.multiline_fields = ('description', 'examples')
    self.data_dict['user_id'] = ''

  def __getitem__(self, key):
    try:
      return self.data_dict[key]
    except :
      return None

  def __setitem__(self, key, item):
    # mapping to match form submission for code reuse
    if key=='pubTests':
      key = 'tests'
    if key=='privTests':
      key='other_tests'
    if key=='userID':
      key='user_id'

    self.data_dict[key] = item

  def __str__(self):
    return str(self.bulk_text)

  def parse(self):
    """ Parses a problem submission into data fillable in the submission
    form
    """
    chunks = self.bulk_text.split('#-')
    for chunk in chunks[1:]:
      # ^^ ignores the first comment line of the problem
      chunk_key, chunk_data = chunk.split(':',1)
      chunk_key = chunk_key.strip()
      if chunk_key in self.multiline_fields:
        # these are data surrounded in triple quotes, single or double
        chunk_data = eval(chunk_data).strip('\r\n')
      else:
        chunk_data = chunk_data.strip().strip('\r\n')
      self[chunk_key] = chunk_data

  def talk(self):
    """ Just a testing function, a submission talks about itself to everyone
    """
    print "Hi I am a submission problem on PyKata,"
    print "Let me tell you something about myself - "
    print "I was created by -", self['userID']
    print "My name is -", self['name']
    print "I belong to these categories -", self['categories']
    print "Here, something more about myself --"
    print self['description']
    print "---------------------------------------"
    print "My solution --"
    print self['solution']
    print "----------------------------------------"
    print "My skeleton --"
    print self['skeleton']
    print "----------------------------------------"
    print "Public Tests --"
    print self['pubTests']
    print "----------------------------------------"
    print "Private Tests --"
    print self['privTests']
    print "----------------------------------------"
    print "\n So tell me something about you too?"


def test_submission_parse():
  import urllib2
#  example_file = urllib2.urlopen('http://ideamonk.in/code/foo.py').read()
  example_file = open('/home/amit/foo2.py').read()
  example_submissions = example_file.split('#---')[1:-1]
  # ^^ ignore the first null string and last __main__ test code
  print example_submissions  
  example_submissions = [ Submission(x) for x in example_submissions ]
  
  for key, a_submission in enumerate(example_submissions):
    print "Problem #", key, "parsed as --"
    print "*************************************************************"
    a_submission.parse()
    a_submission.talk()

if __name__=='__main__':
  # testing
  test_submission_parse()

