# Copyright 2008 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Top-level URL mappings for Rietveld."""

# NOTE: Must import *, since Django looks for things here, e.g. handler500.
import os
import sys
from django.conf.urls.defaults import *
from registration.views import register
from testappproj.testapp.forms import Test_UserForm
from django.contrib import admin


admin.autodiscover()



urlpatterns = patterns('',
                       (r'^$', 'testappproj.testapp.views.index'),
                       url(r'^accounts/register/$',register,{'form_class' : Test_UserForm},name='registration_register'),
    		       (r'^accounts/', include('registration.urls')),
                       (r'^code/(\d+)/$', 'testappproj.testapp.views.code'),
                       (r'^admin/(.*)', admin.site.root),
                       (r'^new/$', 'testappproj.testapp.views.new_edit'),
                       (r'^problems/$', 'testappproj.testapp.views.problems'),
                       (r'^run/$', 'testappproj.testapp.views.run'),
                       (r'^static/(?P<path>.*)$', 'django.views.static.serve',
     		      {'document_root': os.path.realpath(os.path.dirname(
        		sys.modules[__name__].__file__) + '/static/')}),
                       (r'^completed/$','testappproj.testapp.views.complete')

)
                        
