from recaptcha.client import captcha
from django import forms
from registration.forms import RegistrationForm
from django.utils.translation import ugettext_lazy as _
from testapp.models import Test_User
from registration.models import RegistrationProfile
#from google.appengine.ext.db import djangoforms
import models
from django.conf import settings
from django.utils.safestring import mark_safe



attrs_dict = { 'class': 'required' }

PROBLEM_CHOICES=(
    ('P', 'Plotting'),
    ('S', 'Scripting'),
)

SESSION_CHOICES=(
  ('A','DAY 1 SESSION 1'),
  ('B','DAY 1 SESSION 2'),
  ('C','DAY 1 SESSION 3'),
  ('D','DAY 1 SESSION 4'),
  ('E','DAY 2 SESSION 1'),
  ('F','DAY 2 SESSION 2'),
  ('G','DAY 2 SESSION 3'),
  ('H','DAY 2 SESSION 4'),
  )


# class ReCaptcha(forms.Widget):
#     input_type = None # Subclasses must define this.

#     def render(self, name, value, attrs=None):
#         final_attrs = self.build_attrs(attrs, type=self.input_type, name=name)
#         html = u"<script>var RecaptchaOptions = {theme : '%s'};</script>" % (
#             final_attrs.get('theme', 'white'))
#         html += captcha.displayhtml(settings.RECAPTCHA_PUBLIC)
#         return mark_safe(html)

#     def value_from_datadict(self, data, files, name):
#         return {
#             'recaptcha_challenge_field': data.get('recaptcha_challenge_field', None),
#             'recaptcha_response_field': data.get('recaptcha_response_field', None),
#         }

# class ReCaptchaField(forms.FileField):
#     widget = ReCaptcha
#     default_error_messages = {
#         'invalid-site-public-key': u"Invalid public key",
#         'invalid-site-private-key': u"Invalid private key",
#         'invalid-request-cookie': u"Invalid cookie",
#         'incorrect-captcha-sol': u"Invalid entry, please try again.",
#         'verify-params-incorrect': u"The parameters to verify were incorrect, make sure you are passing all the required parameters.",
#         'invalid-referrer': u"Invalid referrer domain",
#         'recaptcha-not-reachable': u"Could not contact reCAPTCHA server",
#     }

#     def clean(self, data, initial):
#         if initial is None or initial == '':
#             raise Exception("ReCaptchaField requires the client's IP be set to the initial value")
#         ip = initial
#         resp = captcha.submit(data.get("recaptcha_challenge_field", None),
#                               data.get("recaptcha_response_field", None),
#                               settings.RECAPTCHA_PRIVATE, ip)
#         if not resp.is_valid:
#             raise forms.ValidationError(self.default_error_messages.get(
#                     resp.error_code, "Unknown error: %s" % (resp.error_code)))



class ProblemForm(forms.Form):
  Description = forms.CharField(widget=forms.Textarea(attrs={'rows': '10', 'cols': '80'}),required=True,help_text="To be used as the question")
  Problem_type = forms.ChoiceField(choices=PROBLEM_CHOICES,required=True)
  Solution = forms.CharField(widget=forms.Textarea(attrs={'rows': '10', 'cols': '80'}),help_text="comma seperated in case of multiple solutions",required=False)
  Solution_Image = forms.ImageField(required=False)
  Session = forms.ChoiceField(choices=SESSION_CHOICES, required=True)
  Credit=forms.IntegerField(required=True)

  class Meta:
   model = models.Problem
   exclude = ('author', 'created', 'modified')



class Test_UserForm(RegistrationForm):

  Fullname = forms.CharField(widget=forms.TextInput(attrs=attrs_dict))
  Address =  forms.CharField(widget=forms.TextInput(attrs=attrs_dict))
#  captcha = ReCaptchaField()

  class Meta:
        exclude = ('special_user','exam_done')


  def save(self, profile_callback=None):
    new_user = RegistrationProfile.objects.create_inactive_user(username=self.cleaned_data['username'],
                                                                password=self.cleaned_data['password1'],
                                                                email=self.cleaned_data['email'])
    new_profile = Test_User(user=new_user, fullname=self.cleaned_data['Fullname'],address=self.cleaned_data['Address'])
    new_profile.save()
    return new_user



class UploadForm(forms.Form):
  file = forms.FileField()

  class Meta:
    model = None
