from django.db import models
from django.contrib.auth.models import User 
from django.contrib.auth.models import Group, Permission


PROBLEM_CHOICES=(
    ('P', 'Plotting'),
    ('S', 'Scripting'),
)


SESSION_CHOICES=(
  ('A','DAY 1 SESSION 1'),
  ('B','DAY 1 SESSION 2'),
  ('C','DAY 1 SESSION 3'),
  ('D','DAY 1 SESSION 4'),
  ('E','DAY 2 SESSION 1'),
  ('F','DAY 2 SESSION 2'),
  ('G','DAY 2 SESSION 3'),
  ('H','DAY 1 SESSION 4'),
  )

class Problem(models.Model):
  # name = models.CharField(blank=False,max_length=255)
  description = models.CharField(blank=False , max_length=255)
  problem_type=models.CharField(blank = False ,max_length=1, choices=PROBLEM_CHOICES)
  solution = models.CharField(blank=True ,max_length=255)
  solution_image = models.ImageField(blank = True ,upload_to='plots')
  session = models.CharField(blank=False ,max_length=1,choices=SESSION_CHOICES)
  author = models.CharField(max_length=255)
  created = models.DateTimeField()
  modified = models.DateTimeField()
  credit=models.IntegerField()


  #if  user.has_perm('testapp.add_bar') and  user.has_perm('foo.change_bar') and user.has_perm('foo.delete_bar')

class Test_User(models.Model):
  #problem = models.ForeignKey('Problem')
  user = models.ForeignKey(User, unique=True)
  fullname=models.CharField(max_length=255,unique=True,blank=False)
  address=models.CharField(max_length=255,unique=True,blank=False)
  exam_done=models.BooleanField(default=False)
  
class Score(models.Model):
  user = models.ForeignKey(User, unique=True)
  total_credits=models.IntegerField(default=0,blank=False)
  


  
  
  
  



