from django.db import models
from django.forms import ModelForm
from django.contrib.auth.models import User, UserManager

from django.utils.translation import ugettext_lazy as _

from datetime import datetime

# Create your models here.

class Participant(models.Model):  
  '''model for holding details of participants
  '''
  PARTICIPANT_CATEGORY = (
		('Student','Student'),
    ('Corporate Staff','Corporate Staff'),
    ('Teacher','Teacher'),
    ('Others','Others'),
	)
  username = models.ForeignKey(User, unique=True, related_name='profile') 
  category = models.CharField(max_length = 80, choices=PARTICIPANT_CATEGORY,)
  organisation = models.CharField(_("Organisation"),max_length=200,blank = True,null = True)
  attending_conf = models.BooleanField(verbose_name="Will you attend conference?")
  attending_tut = models.BooleanField(verbose_name="Will you attend tutorial session?")
  attending_sprint = models.BooleanField(verbose_name="Will you attend sprint?")
  paper_submission = models.BooleanField(verbose_name="Do you want to Submit paper?")

class ParticipantForm(ModelForm):
    class Meta:
        model = Participant        
        #model = User
        #fields = ['username','email','password']

  
class Tempreg(models.Model):
  username = models.CharField(_("User Name"),max_length=30,unique=True)
  email    = models.EmailField(_("Email Address"),unique=True)  
  
  
