from django import forms
from django.utils.translation import ugettext_lazy as _
from content.models import Participant
from django.contrib.auth.models import User

class Participantform(forms.ModelForm):
  class Meta:
    model = Participant

class Registerform(forms.Form):
  """
  Temporary Registration Form.
  """   
  PARTICIPANT_CATEGORY = (
		('Student','Student'),
    ('Corporate Staff','Corporate Staff'),
    ('Teacher','Teacher'),
    ('Others','Others'),
	)
  username = forms.CharField(max_length=30,
                                 label="User Name")
  email = forms.EmailField(max_length=75,
                            label=u'Email address')
  pass1 = forms.CharField(max_length=50,widget=forms.PasswordInput,
                            label=_("Enter New Password"),
                            )
  pass2 = forms.CharField(max_length=50,widget=forms.PasswordInput,
                            label=_("Enter New Password Again"),
                            )
  category = forms.ChoiceField(label=_("Category"),
                                   choices=PARTICIPANT_CATEGORY)
  organiztion = forms.CharField(max_length=200,
                               label=_("Organisation"),
                               required=False)  
  attending_conf = forms.BooleanField(label=_("Will you attend conference?"))
  attending_tut = forms.BooleanField(label=_("Will you attend tutorial session?"),
                     required=False)
  attending_sprint = forms.BooleanField(label=_("Will you attend sprint?"),
                    required=False)              
  
  def save(self):
    '''To create a user and save additional information
    related to user.
    '''
    profile=self.cleaned_data        
    new_user = User.objects.create_user(username=profile.get('username'),
                          password=profile.get('pass1'),
                          email=profile.get('email'))
    participant = Participantform()
    participant.username = profile.get('username')
    participant.category = profile.get('category')
    participant.organiztion = profile.get('organization')
    participant.attending_conf = profile.get('attending_conf')
    participant.attending_tut = profile.get('attending_tut')
    participant.attending_sprint = profile.get('attending_sprint')
    participant.save()
    return new_user
    
class LoginForm(forms.Form):
	username = forms.CharField(max_length=30, label=_(u'username'))
	password = forms.CharField(max_length=50,widget=forms.PasswordInput,
                            label=_("Enter New Password")
                            )
