from datetime import datetime

from django.contrib.auth.models import User
from django.contrib.auth.models import UserManager
from django.db import models
from django.forms import ModelForm
from django.utils.translation import ugettext_lazy as _


class Participant(models.Model):  
  """Model for holding details of participants
  """

  # This is the only required field
  user = models.ForeignKey(User, unique=True)

  PARTICIPANT_CATEGORY = (
       ('Student','Student'),
       ('Corporate Staff','Corporate Staff'),
       ('Teacher','Teacher'),
       ('Others','Others'),
	   )

  category = models.CharField(max_length=80, choices=PARTICIPANT_CATEGORY)

  organisation = models.CharField(_("Organisation"), max_length=200,
                                  blank = True, null=True)

  attending_conf = models.BooleanField(verbose_name="Will you attend the conference?")

  attending_tut = models.BooleanField(verbose_name="Will you attend the tutorial session?")

  attending_sprint = models.BooleanField(verbose_name="Will you attend the sprint?")

  paper_submission = models.BooleanField(verbose_name="Do you want to Submit paper(s)?")
