from django.core.mail import send_mail

def send_reg_complete_mail(email, first_name, last_name):
    """ send registration complete email to the registered user.
    """

    subject = "Sage Days 25, India - Registration"

    message = """
Dear %s %s,

Thank you for registering on Sage Days 25, India. Since we have limited number of seats we will be mailing you the status of your registration shortly.
Meanwhile you may join the Sage Days mailing list/group at [http://groups.google.com/group/sagedays25].

Registration Fee:
There is a registration fee of Rs.200/- and it can be paid on reporting at the conference.

Accommodation:
The accommodation for delegates is limited and hence you shall be notified on the status of your accommodation(if required) soon.

Queries:
Feel free to contact us at sagedays@fossee.in for any queries.

If you did not register for Sage Days 25, please ignore this mail and report the incident to sagedays@fossee.in

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(first_name.title(), last_name.title())

    send_mail(subject, message, "sagedays@fossee.in", [email])

def send_rwd_email(inc):
    
    user = inc.registrant
    sub = "Sage Days - Reward for participation in sprints"

    msg = """
Dear %s, 

Thank you for your enthusiastic participation in Sage days 25. 

You have made a significant contribution during sprints and as promised, you have been selected to receive the following in appreciation of your efforts.
A cash prize of Rs.%s %s

We would be sending the money as DD and hence need your name as it is in your account.

The details you have entered while registering are as follows.

Name: %s
Address: %s

If you would like to change these details, please click this link http://fossee.in/sage_days/registration/cnf_addr/%s?email=%s and update your name and address at the latest by 20:00 IST 7th September, 2010

We hope this reward will encourage you to continue your contribution towards Open Source in general and SAGE in particular.

Thanking You,

Sage Days India Team,
FOSSEE, IIT Bombay.

"""%(user, inc.amount, " and a tshirt" if inc.t_shirt else "", user, user.address, user.id, user.email)

    send_mail(sub, msg, "sagedays@fossee.in", [user.email])

def send_wsp_ptc_confirm(user):
    """ send a mail telling a worksho has been scheduled.
    """

    subject = "Sage Days 25, India - Python Workshop"

    subject_cancellation = "Sage Days 25, India - Cancellation of Python Workshop"

    message_cancellation = """
Dear %s %s,

We are sorry to announce that we are cancelling the one day Pre-Sage Days
workshop which was scheduled on July 31st.

It has been cancelled due to low response from the people who requested 
for the workshop.

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(user.first_name.title(), user.last_name.title())

    message = """
Dear %s %s,

Till now, only one person has confirmed to attend pre-"Sage Days" Python workshop. If there is very little interest for the workshop, there is no point in conducting a workshop. We will hence be forced to annul the workshop. So please confirm your participation in the workshop by 29th July, 2010 afternoon.

We are conducting a one day workshop for people who are new to Python.
Although Python is not a pre requisite for Sage Days, this workshop aims at getting people started with Python so that they can make most out of Sage Days 25.

Date: 31 July, 2010
Duration: 9:00 AM - 6:00 PM
Venue: CFD Lab, Aero Annex, Aerospace Department, IIT Bombay
Pre Requisites: Fresh and Open mind

We shall be giving laptops to people who do not have. But they will be given on First Come First Serve basis and are very limited in number. Hence you are advised to bring your own laptop. http://fossee.in/installation-how-to has the instructions on installing the software that is used in the workshop.

NOTE: Participants have to make their own lunch arrangements.

Please click the link below or paste it in a browser to confirm your participation.
http://fossee.in/sage_days/registration/cnf_wsp_ptc/%s?email=%s

Please ignore this mail if you are not likely to attend the workshop.

PS: If anyone who has not registered for Sage Days or not requested a workshop but is interested in attending, drop a mail to sagedays@fossee.in and we will be happy to have them also at the workshop.

Visit http://fossee.in/sage_days/pre_sage_days_workshop for more details on the workshop.

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(user.first_name.title(), user.last_name.title(), user.id, user.email)

    send_mail(subject_cancellation, message_cancellation, "sagedays@fossee.in", [user.email])


def send_sgd_ptc_confirm(user):
    """ send a mail telling that you have been selected to attend sage days.
    """

    subject = "Sage Days 25, India - Selected for participation"

    message = """
Dear %s %s,

You have been selected to attend Sage Days 25, India.

Please click the link below or paste it in a browser to confirm your participation.
http://fossee.in/sage_days/registration/cnf_sgd_ptc/%s?email=%s

Please ignore this mail if you are not likely to attend Sage Days 25, India.

PS:
Your participation will be confirmed only if you visit the link above at the latest by 5 August, 2010. Mostly you will have to arrange accommodation yourself, since you have registered very late. If you don't hear from us about accommodation, please understand you are not given one.

If by any chance you have not confirmed your participation by 5 August,  2010 and still want to participate, write a mail to sagedays@fossee.in

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(user.first_name.title(), user.last_name.title(), user.id, user.email)

    send_mail(subject, message, "sagedays@fossee.in", [user.email])

def send_cnf_email(user):
    """ send email so that it can be shown at the gate in IIT
    """

    subject = "Sage Days 25, India - Thankyou for confirming participation"

    message = """
Dear %s %s,

Thank you for confirming your participation in Sage Days 25, India.

Please carry a copy of this email, to be shown at the security outpost to enter IIT Bombay.

PS: Take a pass for your Laptop/Camera while entering into the campus.

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(user.first_name.title(), user.last_name.title())

    send_mail(subject, message, "sagedays@fossee.in", [user.email])

def send_acco_confirm_mail(user_obj, venue, amount, bedding=False):
    """ take the given message and add it to main message and send the mail.
    """

    subject = "[Sage Days 25, India] Accommodation details"

    if bedding:
        bedding_content = 'Also it will be helpful for you to carry some '\
            'kind of light bedding although a single mat is likely to be '\
            'provided. '
    else:
        bedding_content = ''

    main_message = """
Dear %(first_name)s %(last_name)s,

  We are pleased to inform that you have been allotted accommodation
during Sage Days 25, as per your request at the time of registration.
Please note that the accommodation availability in IITB is very limited
for residing students and staff themselves and hence we have alloted all
the rooms on twin shared basis for the participants of Sage Days 25. Also
there is a charge involved with the accommodation which is mentioned
below. Kindly oblige. When you arrive at IIT Bombay please feel free to
call Madhusudan.C.S on +91-9987214220 for further details on getting to
the place of accommodation. If Madhusudan is not reachable, as a fall back
please feel free to contact Anoop on +91-8149769093. %(bedding)sPlease
carry your valid Identity card. Also please confirm the requirement of
accommodation as per these conditions by Saturday, Aug 7th, 2010 evening.
If we receive no response from you by 7th evening we will your allot the
accommodation to other participants who are wait-listed now.

Your accommodation venue: %(venue)s
Charge: Rs. %(amount)s per day

Please note that you need to deposit the money for all the four days at
the time of obtaining the accommodation. If you are leaving early we will
reimburse the remaining amount.

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.""" % {
           'first_name': user_obj.first_name.title(),
           'last_name': user_obj.last_name.title(),
           'venue': venue,
           'amount': amount,
           'bedding': bedding_content,
           }

    send_mail(subject, main_message, "sagedays@fossee.in", [user_obj.email])

def send_acco_reject_mail(user_obj):
    """ Send the accommodation reject mail.
    """

    subject = "[Sage Days 25, India] Accommodation details"

    main_message = """
Dear %(first_name)s %(last_name)s,

  We regret to inform you that we haven't been able to allot accommodation
to you because of a lot of demand and the facilities in IIT Bombay is
extremely limited. Although we haven't completely rejected your request.
You have been wait-listed for accommodation and if participants who have
been alloted accommodation don't confirm by 7th August, 2010 evening we
will allot them to the wait-listed participants. Although please note, if
alloted accommodation, there will be charges associated with
accommodation, the details of which will be sent if you have been given
accommodation.

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.""" % {
           'first_name': user_obj.first_name.title(),
           'last_name': user_obj.last_name.title()
           }

    send_mail(subject, main_message, "sagedays@fossee.in", [user_obj.email])

def mail_invi(to_emails):
    """ send the invitation email to given email addresses.
    """

    subject = "Invitation to Sage Days 25, India"

    message = """
Sage Days 25 - An Invitation

What is 'Sage Days'?
Sage Days is a confluence of present and prospective SAGE Users and Developers. It is an opportunity to come together to share ideas,
brainstorm and hack on Sage.

Sage Days 25 is the 25th version of Sage Days, and is being organized in Mumbai, India. In order to cater to an Indian audience and scenario, this version has been tweaked slightly. Sage Days 25 has beginner level tutorials, in addition to the usual talks and sprints, to help new users get started with Sage and help promote the use of Sage in India.

What is Sage?
Sage is a free, open-source mathematics software system licensed under the GPL. It combines the power of numerous existing open-source packages into a common Python-based interface. It's mission is to create a "viable free open source alternative to Magma, Maple, Mathematica and Matlab".

Sage has tools for a broad range of mathematical areas like Linear Algebra, Calculus, Symbolic Math,  Plotting, Rings & Groups, Graph Theory, Number Theory and Cryptography. Essentially, "it can do anything from mapping a 12-dimensional object to calculating rainfall patterns under global warming" - as Science Daily puts it . Eager to get started? Start here. [#1]

Apart from being feature rich, it's usability is one of it's greatest strengths. Sage Notebook, a web-interface for all the math you'll ever want to do, is really the killer feature! As the Sage Marketing page says, "The SAGE GUI surely works on your computer box, because it just runs in Firefox!".  Try it Now! [#2]

Why should you attend?
Sage Days 25 is being attended by the creator and lead developer of Sage, Prof. William Stein. It will also be attended by other developers of Sage. This would be a great opportunity to meet and interact with them!

The conference will be attended by a plethora of enthusiastic people from all over the country who use Sage or are interested in doing so. The conference will also see the presence of many mathematicians interested in software. Who knows, you may run into someone you'd want to collaborate with, for your future work!

This event will be a great learning experience, if you are even remotely interested in math and software for it!

When and Where?
Venue: IIT-Bombay, Mumbai, India
Dates: August 9-12, 2010

Tentative Schedule: http://fossee.in/sage_days/schedule/
Register Here: http://fossee.in/sage_days/registration/register/

[#1] http://www.sagemath.org/tour.html
[#2] http://www.sagenb.org/

--
Sage Days India Team,
FOSSEE, IIT Bombay.

"""

    for emails in to_emails:
        send_mail(subject, message, "sagedays@fossee.in", emails)


def mail_cust_invi(to_emails):
    """ send the custom invitation email to given email addresses.
    """

    subject = "SciPy 2010 Call for Papers & Participation"

    message = """
==========================================
SciPy 2010 Call for Papers & Participation
==========================================

The second SciPy India Conference (scipy.in) will be held from December 13th to 18th, 2010 at IIIT-Hyderabad (http://www.iiit.ac.in/).

Scipy.in is a conference providing opportunities to spread the use of the Python programming language in the Scientific Computing community in India. It provides a unique opportunity to interact with the "Who's who" of the Python for Scientific Computing fraternity and learn, understand, participate and contribute what is happening in the realms of Scientific Computing using Python. Attendees of the conference and participants of the sprints planned will be able to access and review the tools available, apart from learning domain-specific applications and how the tools apply to a plethora of application problems.

One of the goals of the conference is to combine education, engineering and science with computing through the medium of Python and thereby extrapolate on how powerful Scientific Computing is in various fields and among different communities.

At this conference, novel applications and breakthroughs made in the pursuit of science using Python are presented.  Attended by leading figures from both academia and industry, it is an excellent opportunity to experience the cutting edge of scientific software development.

The conference is followed by three days of tutorials and code sprints, during which community experts provide training on several scientific Python packages.

We invite you to take part by submitting a talk abstract or register as a participant on the conference website at: http://scipy.in

Talk/Paper Submission
=====================

We solicit talks and accompanying papers (either formal academic or magazine-style articles) that discuss topics regarding scientific computing using Python, including applications, teaching, development and research.  Papers are included in the peer-reviewed conference proceedings, published online.

Please note that submissions primarily aimed at the promotion of a commercial product or service will not be considered.

Important Dates
===============

Wednesday, Nov. 10: Abstracts Due
Monday, Nov. 15: Schedule announced
Sunday, Dec. 05: Proceedings paper submission due
Monday-Tuesday, Dec. 13-14: Conference
Wednesday-Friday, Dec. 15-17: Tutorials/Sprints
Saturday, Dec. 18: Sprints

The invited speakers
==================

* Fernando Perez -- PhD from University of Colorado.  Currently at the Helen Wills Neuroscience Institute at the University of California, Berkeley.  Original author and leader of the IPython project for interactive computing (http://ipython.scipy.org), and member of the Python Software Foundation.

* John Hunter -- Ph.D. from University of Chicago.  Currently at Tradelink, Inc. Chicago.  Original author and lead developer of the scientific visualization package matplotlib.

* Perry Greenfield -- PhD, MIT. Currently at Space Telescope Science Institute, Maryland, USA.  Has pioneered the use of Python in astronomy. He and his group have developed PyRAF, numarray (the precursor to current numpy capabilities), PyFITS and involved with the development of matplotlib.

* Prabhu Ramachandran -- PhD, IIT Madras.  Currently a faculty member at IIT Bombay.  He is the co-founder of the Indian Linux User Group - Chennai (ILUGC) and is the creator and lead developer of the (FOSS-India-award-winning) Mayavi and TVTK Python packages (http://code.enthought.com/projects/mayavi). Currently heads the FOSSEE (http://fossee.in) project.

* Stefan van der Walt -- PhD, Stellenbosch University, SA. Currently a researcher and lecturer in Applied Mathematics at Stellenbosch University.  One of the developers of the NumPy and SciPy packages.

* Jarrod Millman -- Member of the SciPy steering committee and an active contributor to both the NumPy and SciPy projects. He is the acting managing director and the director of computing for UC Berkeley's Neuroscience Institute, where he helped found the Neuroimaging in Python (NiPy) project.


* Satrajit Ghosh -- PhD Boston University.  Currently a faculty member of the Speech and Hearing Biosciences and Technology program, Harvard-MIT. He is managing the development of the NiPy project (http://nipy.org/nipype/).

* Asokan Pichai -- Head - Software Engineering at TalentSprint. Consultant/Project manager for the Python group of the FOSSEE project. He has immense experience in the field of training and instructional design.

Organizers
==========

* Jarrod Millman, Neuroscience Institute, UC Berkeley, USA (Conference Co-Chair)
* Prabhu Ramachandran, Department of Aerospace Engineering, IIT Bombay, India (Conference Co-Chair)
* FOSSEE Team
* EnhanceEdu Team

About Python
============

Python is an interpreted, interactive, object-oriented, open source, extensible programming language. It combines clarity and readability, making it an extremely powerful language that can be used for various applications and problems.

Python is simple and easy to learn and apply. It offers an interactive environment in which to explore procedural, functional and object oriented approaches to problem solving. Its high level data structures, extensive documentation and clear syntax make it an ideal first language, while the large number of existing libraries make it suitable to tackle almost any programming tasks. Its simplicity makes it easy to adapt to multiple educational domains.

Python has several libraries that enable numeric and symbolic computing. It also interfaces well with native codes in C,C++ and FORTRAN and has excellent libraries for plotting/visualization. Python also provides libraries for general purpose computing including generating user interfaces and web development. These, coupled with it's interactive interpreter, make Python an excellent language for Scientific Computing.

All these features when combined with their wide-ranging applications make Python a perfect fit for use in Education, Industry and Scientific Computing.

Registration Fees
===============

Registration, accommodation and food are offered at highly subsidized rates for teachers and students, while registration and food will be offered to all conference participants at subsidized rates. Details about the fees can be found at: http://scipy.in/scipyin/2010/about/fees/

Publicity
========

The posters can be downloaded from the website : http://scipy.in/scipyin/2010/publicity/

Contact
=======

Feel free to email the organizers at info@scipy.in

--
Scipy India Team,
FOSSEE, IIT Bombay.

www.scipy.in
"""

    for emails in to_emails:
        send_mail(subject, message, "info@scipy.in", emails)

