from django.contrib import admin

from sage_days.sdi.models import ParticipantInfo
from sage_days.sdi.models import Registrant
from sage_days.sdi.models import RegistrantInfo


class RegistrantAdmin(admin.ModelAdmin):
    list_display = ('first_name', 'last_name')
    list_filter = ('first_name', 'last_name')
    search_fields = ('first_name', 'last_name')
admin.site.register(Registrant, RegistrantAdmin)


class ParticipantInfoAdmin(admin.ModelAdmin):
    list_display = ('participant', 'has_laptop_for_sagedays', 'sprinted_already', 'will_sprint') 
    list_filter = ('participant', 'has_laptop_for_sagedays', 'sprinted_already', 'will_sprint')
    search_fields = ('participant', 'has_laptop_for_sagedays', 'sprinted_already', 'will_sprint')
admin.site.register(ParticipantInfo, ParticipantInfoAdmin)


class RegistrantInfoAdmin(admin.ModelAdmin):
    list_display = ('registrant', 'status_of_attending_sagedays', 'status_of_attending_workshop', 'status_of_accomodation', 'has_laptop_for_workshop', 'acco_location')
    list_filter = ('registrant', 'status_of_attending_sagedays', 'status_of_attending_workshop', 'status_of_accomodation', 'has_laptop_for_workshop', 'acco_location')
    search_fields = ('registrant', 'status_of_attending_sagedays', 'status_of_attending_workshop', 'status_of_accomodation', 'has_laptop_for_workshop', 'acco_location')
admin.site.register(RegistrantInfo, RegistrantInfoAdmin)
