from django.core.mail import send_mail

def send_reg_complete_mail(email, first_name, last_name):
    """ send registration complete email to the registered user.
    """

    subject = "Sage Days 25, India - Registration"

    message = """
Dear %s %s,

Thank you for registering on Sage Days 25, India. Since we have limited number of seats we will be mailing you the status of your registration shortly.
Meanwhile you may join the Sage Days mailing list/group at [http://groups.google.com/group/sagedays25].

Registration Fee:
There is a registration fee of Rs.200/- and it can be paid on reporting at the conference.

Accommodation:
The accommodation for delegates is limited and hence you shall be notified on the status of your accommodation(if required) soon.

Queries:
Feel free to contact us at sagedays@fossee.in for any queries.

If you did not register for Sage Days 25, please ignore this mail and report the incident to sagedays@fossee.in

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(first_name.title(), last_name.title())

    send_mail(subject, message, "sagedays@fossee.in", [email])

def send_wsp_ptc_confirm(user):
    """ send a mail telling a worksho has been scheduled.
    """

    subject = "Sage Days 25, India - Python Workshop"

    message = """
Dear %s %s,

We are conducting a one day workshop for people who are new to Python.
Although Python is not a pre requisite for Sage Days, this workshop aims at getting people started with Python so that they can make most out of Sage Days 25.

Date: 31 July, 2010
Duration: 9:00 AM - 6:00 PM
Venue: CFD Lab, Aero Annex, Aerospace Department, IIT Bombay
Pre Requisites: Fresh and Open mind

We shall be giving laptops to people who do not have. But they will be given on First Come First Serve basis and are very limited in number. Hence you are advised to bring your own laptop. http://fossee.in/installation-how-to has the instructions on installing the software that is used in the workshop.

NOTE: Participants have to make their own lunch arrangements.

Please click the link below or paste it in a browser to confirm your participation.
http://fossee.in/sage_days/registration/cnf_wsp_ptc/%s?email=%s

Please ignore this mail if you are not likely to attend the workshop.

PS: If anyone who has not registered for Sage Days or not requested a workshop but is interested in attending, drop a mail to sagedays@fossee.in and we will be happy to have them also at the workshop.

Visit http://fossee.in/sage_days/pre_sage_days_workshop for more details on the workshop.

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(user.first_name.title(), user.last_name.title(), user.id, user.email)

    send_mail(subject, message, "sagedays@fossee.in", [user.email])


def send_sgd_ptc_confirm(user):
    """ send a mail telling that you have been selected to attend sage days.
    """

    subject = "Sage Days 25, India - Selected for participation"

    message = """
Dear %s %s,

You have been selected to attend Sage Days 25, India.

Please click the link below or paste it in a browser to confirm your participation.
http://fossee.in/sage_days/registration/cnf_sgd_ptc/%s?email=%s

Please ignore this mail if you are not likely to attend Sage Days 25, India.

PS:
Your participation will be confirmed only if you visit the link above at the latest by 26 July, 2010.
If you by any chance have not confirmed your participation by 26 July,  2010 and still want to participate, write a mail to sagedays@fossee.in

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(user.first_name.title(), user.last_name.title(), user.id, user.email)

    send_mail(subject, message, "sagedays@fossee.in", [user.email])

def send_cnf_email(user):
    """ send email so that it can be shown at the gate in IIT
    """

    subject = "Sage Days 25, India - Thankyou for confirming participation"

    message = """
Dear %s %s,

Thank you for confirming your participation in Sage Days 25, India.

Please carry a copy of this email, to be shown at the security outpost to enter IIT Bombay.

PS: Take a pass for your Laptop/Camera while entering into the campus.

Thanking you,

Sage Days India Team,
FOSSEE, IIT Bombay.
    """%(user.first_name.title(), user.last_name.title())

    send_mail(subject, message, "sagedays@fossee.in", [user.email])




def mail_invi(to_emails):
    """ send the invitation email to given email addresses.
    """

    subject = "Invitation to Sage Days 25, India"

    message = """
Sage Days 25 - An Invitation

What is 'Sage Days'?
Sage Days is a confluence of present and prospective SAGE Users and Developers. It is an opportunity to come together to share ideas,
brainstorm and hack on Sage.

Sage Days 25 is the 25th version of Sage Days, and is being organized in Mumbai, India. In order to cater to an Indian audience and scenario, this version has been tweaked slightly. Sage Days 25 has beginner level tutorials, in addition to the usual talks and sprints, to help new users get started with Sage and help promote the use of Sage in India.

What is Sage?
Sage is a free, open-source mathematics software system licensed under the GPL. It combines the power of numerous existing open-source packages into a common Python-based interface. It's mission is to create a "viable free open source alternative to Magma, Maple, Mathematica and Matlab".

Sage has tools for a broad range of mathematical areas like Linear Algebra, Calculus, Symbolic Math,  Plotting, Rings & Groups, Graph Theory, Number Theory and Cryptography. Essentially, "it can do anything from mapping a 12-dimensional object to calculating rainfall patterns under global warming" - as Science Daily puts it . Eager to get started? Start here. [#1]

Apart from being feature rich, it's usability is one of it's greatest strengths. Sage Notebook, a web-interface for all the math you'll ever want to do, is really the killer feature! As the Sage Marketing page says, "The SAGE GUI surely works on your computer box, because it just runs in Firefox!".  Try it Now! [#2]

Why should you attend?
Sage Days 25 is being attended by the creator and lead developer of Sage, Prof. William Stein. It will also be attended by other developers of Sage. This would be a great opportunity to meet and interact with them!

The conference will be attended by a plethora of enthusiastic people from all over the country who use Sage or are interested in doing so. The conference will also see the presence of many mathematicians interested in software. Who knows, you may run into someone you'd want to collaborate with, for your future work!

This event will be a great learning experience, if you are even remotely interested in math and software for it!

When and Where?
Venue: IIT-Bombay, Mumbai, India
Dates: August 9-12, 2010

Tentative Schedule: http://fossee.in/sage_days/schedule/
Register Here: http://fossee.in/sage_days/registration/register/

[#1] http://www.sagemath.org/tour.html
[#2] http://www.sagenb.org/

--
Sage Days India Team,
FOSSEE, IIT Bombay.

"""

    for emails in to_emails:
        send_mail(subject, message, "sagedays@fossee.in", emails)

