from django.db import models

GENDER_CHOICES = (('M', "Male"),
                  ("F", "Female"),
                 )

LIKELINESS_CHOICES = (('5', "Will attend at any cost"),
                      ('4', "Will attend most probably"),
                      ('3', "Unsure of attending"),
                      ('2', "Might not attend"),
                      ('1', "Will not attend"),
                     )


class Registrant(models.Model):
    """ A model to hold the details of registered users.
    """

    first_name = models.CharField(max_length=30, required=True)
    last_name =  models.CharField(max_length=30, required=True)
    email = models.EmailField(required=True)
    gender = models.CharField(max_length=1, required=True, choices=GENDER_CHOICES)

    profession = models.CharField(max_length=20, required=True)
    affiliated_to = models.CharField(max_length=30, required=True)

    topics_interested = models.TextField()
    knowledge_of_python = models.TextField()
    need_for_python_workshop = models.BooleanField()
    knowledge_of_sage = models.TextField()

    tools_used = models.TextField()

    phone_num = models.CharField(max_length=15, required=True)
    address = models.TextField()

    likeliness_of_attending = models.CharField(max_length=1, required=True, choices=LIKELINESS_CHOICES)

