# Note: Most of the code below is hard coded with values. Please change it
# required. Reprensented as (HC) for Hard Coded values.

from sage_days.sdi.events import send_acco_confirm_mail
from sage_days.sdi.events import send_acco_reject_mail
from sage_days.sdi.models import ParticipantInfo, RegistrantInfo


def allot():
    """Performs the allotment of accomodation based on availability for the
       participants who have requested accommodation.
    """

    # (HC)
    # Availability for number of people at various locations. Here in the
    # Order of IITB Hostel, IITB Guest house and then NITIE
    availability = [30, 20, 20]

    # (HC)
    acco_info = ParticipantInfo.objects.filter(
        participant__acco_required=True)
    acco_given = acco_info[:65]
    acco_rejected = acco_info[65:]

    for participant in acco_given:
        if availability[0] <= 0:
            break
        if participant.will_sprint == '3' or participant.will_sprint == '2':
            if participant.participant.profession.lower() == 'student':
                reg_info = participant.participant.registrantinfo_set.get()
                reg_info.status_of_accomodation = '2'
                reg_info.acco_location = '0'
                availability[0] -= 1
                reg_info.save()

    for participant in acco_given:
        if availability[1] <= 0:
            break
        if participant.participant.gender == 'F':
            reg_info = participant.participant.registrantinfo_set.get()
            reg_info.status_of_accomodation = '2'
            reg_info.acco_location = '1'
            availability[1] -= 1
            reg_info.save()
        if participant.participant.gender == 'M':
            if (participant.will_sprint == '3' or
                participant.will_sprint == '2'):
                if participant.participant.profession.lower() != 'student':
                    reg_info = participant.participant.registrantinfo_set.get()
                    reg_info.status_of_accomodation = '2'
                    reg_info.acco_location = '1'
                    availability[1] -= 1
                    reg_info.save()

    for participant in acco_given:
        if availability[2] <= 0:
            break
        if (participant.will_sprint == '1'
            and participant.participant.gender == 'M'):
            reg_info = participant.participant.registrantinfo_set.get()
            reg_info.status_of_accomodation = '2'
            reg_info.acco_location = '2'
            availability[2] -= 1
            reg_info.save()

    for participant in acco_given:
        reg_info = participant.participant.registrantinfo_set.get()
        reg_info.status_of_accomodation = '3'
        reg_info.save()

def send_mails():
    """Sends mails to all those who have been alloted accommodation.
    """

    hostel_participants = RegistrantInfo.objects.filter(
        status_of_accomodation=2, acco_location=0)
    ghouse_partiticpants = RegistrantInfo.objects.filter(
        status_of_accomodation=2, acco_location=1)
    nitie_participants = RegistrantInfo.objects.filter(
        status_of_accomodation=2, acco_location=2)
    acco_rejected = RegistrantInfo.objects.filter(
        status_of_accomodation=3)

    for p in hostel_participants:
        send_acco_confirm_mail(p.registrant, 'IIT Bombay Hostel',
                               '150', True)

    for p in ghouse_partiticpants:
        send_acco_confirm_mail(p.registrant, 'IIT Bombay Guest House', '300')

    for p in nitie_participants:
        send_acco_confirm_mail(p.registrant, 'NITIE House', '500')
  
    for p in acco_rejected:
        send_acco_reject_mail(p.registrant)
  
    
#65
#Participants attending sprints: 21
#Female participants attending sprints: 2
#Male participants attending sprints: 19
#Female participants may be attending sprints: 4
#Male participants may beattending sprints: 21
