from django.db import models

GENDER_CHOICES = (('M', "Male"),
                  ("F", "Female"),
                 )

PYTHON_KNOWLEDGE_CHOICES = (("5", "Written production level code in Python"),
                            ("4", "Been using Python for quite some time"),
                            ("3", "Solved some basic problems using Python"),
                            ("2", "I know for sure that Python is a language"),
                            ("1", "No clue what Python is"),
                           )

SAGE_KNOWLEDGE_CHOICES = (("5", "Written production level code in Sage"),
                          ("4", "Been using Sage for quite some time"),
                          ("3", "Solved some basic problems using Sage"),
                          ("2", "I know for sure that Sage is a language"),
                          ("1", "No clue what Sage is"),
                         )

LIKELINESS_CHOICES = (('5', "Will attend at any cost"),
                      ('4', "Will attend most probably"),
                      ('3', "Unsure of attending"),
                      ('2', "Might not attend"),
                      ('1', "Will not attend"),
                     )

class Registrant(models.Model):
    """ A model to hold the details of registered users.
    """

    first_name = models.CharField(max_length=30)
    last_name =  models.CharField(max_length=30)
    email = models.EmailField()
    gender = models.CharField(max_length=1, choices=GENDER_CHOICES)

    profession = models.CharField(max_length=20)
    affiliated_to = models.CharField(max_length=30)

    topics_interested = models.CharField(max_length=30)

    knowledge_of_python = models.CharField(max_length=1, choices=PYTHON_KNOWLEDGE_CHOICES)
    need_for_python_workshop = models.BooleanField(verbose_name="Do you need a workshop on Python before you attend Sage Days")

    knowledge_of_sage = models.CharField(max_length=1, choices=SAGE_KNOWLEDGE_CHOICES)
    tools_used = models.TextField(help_text="Ex: Scilab, Mathematica, Matlab etc.", verbose_name="Other tools used", blank=True)

    address = models.TextField(help_text="To send DVD containing tutorials on Python if required.")
    phone_num = models.CharField(max_length=15)

    likeliness_of_attending = models.CharField(max_length=1, choices=LIKELINESS_CHOICES)

