from django.db import models

GENDER_CHOICES = (('M', "Male"),
                  ("F", "Female"),
                 )

PYTHON_KNOWLEDGE_CHOICES = (("1", "No clue what Python is"),
                            ("2", "I know for sure that Python is a language"),
                            ("3", "Solved some basic problems using Python"),
                            ("4", "Been using Python for quite some time"),
                            ("5", "Written production level code in Python"),
                           )

SAGE_KNOWLEDGE_CHOICES = (("1", "No clue what Sage is"),
                          ("2", "I know for sure that Sage is a mathematical software"),
                          ("3", "Solved some basic problems using Sage"),
                          ("4", "Been using Sage for quite some time"),
                          #("5", "Written production level code in Sage"),
                         )

TOPICS_CHOICES = (("1", "Cryptography"),
                  ("2", "Basic Algebra"),
                  ("3", "Calculus"),
                  ("4", "Arbitrary Precision Numerics"),
                  ("5", "Basic Plotting"),
                  ("6", "Number Theory"),
                  ("7", "Polynomials"),
                  ("8", "Combinatorics and Graph Theory"),                                          
                 )

LIKELINESS_CHOICES = (('5', "Will attend at any cost"),
                      ('4', "Will attend most probably"),
                      ('3', "Unsure of attending"),
                      ('2', "Might not attend"),
                      ('1', "Will not attend"),
                     )

T_SHIRT_CHOICES = (("S","S"),
                   ("M","M"),
                   ("L","L"),
                   ("XL","XL"),                   
                  )

SPRINT_CHOICES = (("3", "Will sprint for sure"),
                  ("2", "May sprint"),
                  ("1", "Not my cup of tea"))

EVENT_ATTEND_CHOICES = (("5", "Is attending"),
                        ("3", "Has been selected but not confirmed participation"),
                        ("1", "Has registered and is willing to attend"),
                        ("0", "has registered but might not attend"))

WORKSHOP_ATTEND_CHOICES = (("3", "Is attending"),
                           ("2", "Has been selected but not confirmed participation"),
                           ("1", "Has requested for a workshop"),
                           ("0", "Does not need a workshop"))

ACCO_CHOICES = (("3", "Has requested but request has been rejected"),
                ("2", "Has been given accomodation"),
                ("1", "Has requested for accomodation"),
                ("0", "Does not need acco"))

ACCO_LOCATION_CHOICES = (("2", "NITIE"),
                         ("1", "IITB Guest house"),
                         ("0", "IITB Hostel"))

class Registrant(models.Model):
    """ A model to hold the details of registered users.
    """

    first_name = models.CharField(max_length=30)
    last_name =  models.CharField(max_length=30)
    email = models.EmailField()
    gender = models.CharField(max_length=1, choices=GENDER_CHOICES)
    t_shirt_size = models.CharField(max_length=2, choices=T_SHIRT_CHOICES, verbose_name="T-Shirt size")

    profession = models.CharField(max_length=20)
    affiliated_to = models.CharField(max_length=30, verbose_name="Affiliated Institution/Company")

    topics_interested = models.CharField(max_length=30, blank=True)

    knowledge_of_python = models.CharField(max_length=1, choices=PYTHON_KNOWLEDGE_CHOICES)
    need_for_python_workshop = models.BooleanField(verbose_name="Do you need a workshop on Python before you attend Sage Days")

    knowledge_of_sage = models.CharField(max_length=1, choices=SAGE_KNOWLEDGE_CHOICES)
    tools_used = models.TextField(help_text="Ex: Scilab, Mathematica, Matlab etc.", verbose_name="Other tools used", blank=True)

    #address = models.TextField(help_text="To send DVD containing tutorials on Python if required.", blank=True)
    address = models.TextField(blank=True)
    phone_num = models.CharField(max_length=15, verbose_name="Phone Number", blank=True)
    acco_required = models.BooleanField(verbose_name="Need accomodation", default=False)

    priority_for_attending = models.CharField(max_length=1, default="3")
    selected_for_attending = models.BooleanField(default=False)
    
    likeliness_of_attending = models.CharField(max_length=1, choices=LIKELINESS_CHOICES)

    def __unicode__(self):

        return self.first_name + " " + self.last_name

class ParticipantInfo(models.Model):

    participant = models.ForeignKey(Registrant)
    has_laptop_for_sagedays = models.BooleanField(verbose_name="Will you bring your own laptop for Sage Days 25", default=False)

    sprinted_already = models.BooleanField(verbose_name="Have you participated in any kind of coding sprints", default=False)
    will_sprint = models.CharField(max_length=1, verbose_name="Will you sprint", 
                                   default='1', choices=SPRINT_CHOICES)
   
class RegistrantInfo(models.Model):

    registrant = models.ForeignKey(Registrant)
    status_of_attending_sagedays = models.CharField(max_length=1, default="0", choices=EVENT_ATTEND_CHOICES)
    status_of_attending_workshop = models.CharField(max_length=1, default="0", choices=WORKSHOP_ATTEND_CHOICES)
    status_of_accomodation = models.CharField(max_length=1, default="0", choices=ACCO_CHOICES)
    has_laptop_for_workshop = models.BooleanField(default=False)
    acco_location = models.CharField(max_length=1, choices=ACCO_LOCATION_CHOICES, null=True)
