from django.shortcuts import render_to_response, redirect

from sage_days.sdi.models import Registrant
from sage_days.sdi.forms import RegisterForm

def register(request):
    """ The user register page.
    """

    if request.method == "POST":
        form = RegisterForm(request.POST)
        if form.is_valid():
            form.save()
            return redirect("/registration/complete")
        else:
            return render_to_response("register.html", {"form":form})
    else:
        form = RegisterForm()
        return render_to_response("register.html", {"form":form})

def reg_complete(request):
    """ Tell the registration is successful.
    """

    return render_to_response("reg_complete.html")

def list_stats(request):
    """ List the statiscs of registered participants.
    """

    return redirect("/registration/complete")
