from django import forms

from sage_days.sdi.models import Registrant, TOPICS_CHOICES

class RegisterForm(forms.ModelForm):
    """ The form that is displayed to user.
    """

    topics_interested = forms.MultipleChoiceField(widget=forms.CheckboxSelectMultiple, choices=TOPICS_CHOICES, required=False)
    class Meta:
        model = Registrant

    def clean_email(self):
        """ See if the user has already registered using the email.
        """

        email = self.cleaned_data['email'].strip()
        try:
            Registrant.objects.get(email__iexact=email)
            raise forms.ValidationError("This email is already registered. Did you register earlier??")
        except Registrant.DoesNotExist:
            return email

    def clean_topics_interested(self):
        """ Join the choices using PIPE character and store them.
        """

        topics = self.cleaned_data['topics_interested']
        return "|".join(topics)
