from django.shortcuts import render_to_response, redirect
from django.http import HttpResponse
from django.contrib.auth.decorators import login_required

from django.contrib.auth import authenticate, login, logout

from sage_days.sdi.models import Registrant
from sage_days.sdi.forms import RegisterForm, SearchForm, EmailForm, LoginForm
from sage_days.sdi.events import send_reg_complete_mail, mail_invi
from sage_days.settings import APACHE_URL_PREFIX as aup

def register(request):
    """ The user register page.
    """

    if request.method == "POST":
        form = RegisterForm(request.POST)
        if form.is_valid():
            form.save()

            data = form.cleaned_data
            first_name = data['first_name']
            last_name = data['last_name']
            email = data['email']
            send_reg_complete_mail(email, first_name, last_name)

            return redirect("/sage_days/registration/complete")
        else:
            return render_to_response("register.html", {"form":form})
    else:
        form = RegisterForm()
        return render_to_response("register.html", {"form":form})

def reg_complete(request):
    """ Tell the registration is successful.
    """

    return render_to_response("reg_complete.html")

@login_required
def list_stats(request):
    """ List the statiscs of registered participants.
    """

    if request.method == "POST":
        form = SearchForm(request.POST)
        if form.is_valid():
            data = form.cleaned_data

            #need_workshop = data['need_for_python_workshop']
            #acco_required = data['need_accomodation']
            #db_query = "Registrant.objects.filter(need_for_python_workshop=%s, acco_required=%s)"%(need_workshop, acco_required)
            db_query = "Registrant.objects"

            topics_include, topics_exclude = data['topics_interested']
            for number in topics_include:
                db_query += '.filter(topics_interested__contains="%s")'%number

            for number in topics_exclude:
                db_query += '.exclude(topics_interested__contains="%s")'%number

            start_python, stop_python = data['knowledge_of_python']
            if start_python and stop_python:
                db_query += '.filter(knowledge_of_python__gte="%s")'%start_python
                db_query += '.filter(knowledge_of_python__lte="%s")'%stop_python
            elif start_python:
                db_query += '.filter(knowledge_of_python__exact="%s")'%start_python

            start_sage, stop_sage = data['knowledge_of_sage']
            if start_sage and stop_sage:
                db_query += '.filter(knowledge_of_sage__gte="%s")'%start_sage
                db_query += '.filter(knowledge_of_sage__lte="%s")'%stop_sage
            elif start_sage:
                db_query += '.filter(knowledge_of_sage__exact="%s")'%start_sage

            start_likeliness, stop_likeliness = data['likeliness_of_attending']
            if start_likeliness and stop_likeliness:
                db_query += '.filter(likeliness_of_attending__gte="%s")'%start_likeliness
                db_query += '.filter(likeliness_of_attending__lte="%s")'%stop_likeliness
            elif start_likeliness:
                db_query += '.filter(likeliness_of_attending__exact="%s")'%start_likeliness

            db_query += ".all()"

            matches = eval(db_query)
            return render_to_response("list_stats.html", {"form":form, 'matches':matches})
        else:
            return render_to_response("list_stats.html", {"form":form})
    else:
        form = SearchForm()
        return render_to_response("list_stats.html", {"form":form})

@login_required
def send_invi(request):
    """ Take a list of csv email addresses and send mails to them.
    """

    if request.method == "POST":
        form = EmailForm(request.POST)
        if form.is_valid():
            to_emails = form.cleaned_data['emails']
            mail_invi(to_emails)
            return render_to_response("send_invi.html", {"emails":to_emails})
        else:
            return render_to_response("send_invi.html", {"form":form})
    else:
        form = EmailForm()
        return render_to_response("send_invi.html", {"form":form})

@login_required
def send_workshop_confirm(request):
    """ Show a list of all the ppl who requested for a workshop and 
    send a confirmation mail to them if not sent.
    """

    matches = Registrant.objects.filter(need_for_python_workshop=True, registrantinfo__status_of_attending_workshop="0")
    if request.method == "POST":
        pass
    else:
        return render_to_response("send_workshop_confirm.html", {"matches":matches}) 

def admin_login(request):
    """ basic login.
    """

    redirect_url = "/%s/registration/stats"%aup

    user = request.user
    if user.is_authenticated():
        return redirect(redirect_url)

    if request.method == "POST":
        form = LoginForm(request.POST)
        if form.is_valid():
            data = form.cleaned_data

            username = data['username']
            password = data['password']

            user = authenticate(username=username, password=password)
            login(request, user)
            return redirect(redirect_url)
        else:
            return render_to_response("login.html", {"form":form})
    else:
        form = LoginForm()
        return render_to_response("login.html", {"form":form})

@login_required
def admin_logout(request):
    """ simply logout.
    """

    logout(request)
    return render_to_response("logout.html")

def homepage(request):
        return render_to_response("index.html")

def schedule(request):
	return render_to_response("schedule.html")

def organizers(request):
	return render_to_response("organizers.html")

def venue(request):
	return render_to_response("venue.html")

def contact(request):
	return render_to_response("contact.html")

def about(request):
	return render_to_response("about.html")
	
def accomodation(request):
	return render_to_response("accomodation.html")

def about_venue(request):
    return render_to_response("about_venue.html")

def about_mumbai(request):
    return render_to_response("about_mumbai.html")

def reaching_iitb(request):
    return render_to_response("reaching_iitb.html")
