#!/usr/bin/python2.5
#
# Copyright 2008 the Melange authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Module contains rights memcache functions.
"""

__authors__ = [
    '"Sverre Rabbelier" <sverre@rabbelier.nl>',
  ]


from google.appengine.api import memcache


RIGHTS = [
    'checkAccess',
    'checkCanCreateFromRequest',
    'checkCanMakeRequestToGroup',
    'checkCanProcessRequest',
    'checkHasPickGetArgs',
    'checkHasUserEntity',
    'checkIsActive',
    'checkIsApplicationAccepted',
    'checkIsClubAdminForClub',
    'checkIsDeveloper',
    'checkIsDocumentPublic',
    'checkIsGroupActive',
    'checkIsHost',
    'checkIsHostForSponsor',
    'checkIsLoggedIn',
    'checkIsMyActiveRole',
    'checkIsMyApplication',
    'checkIsMyGroupAcceptedRequest',
    'checkIsMyNotification',
    'checkIsUnusedAccount',
    'checkIsUser',
    'checkNotLoggedIn',
    ]


def flush(id):
  """Flushes all ACL's for the specified account.
  """

  key_prefix = '%s.' % id
  memcache.delete_multi(RIGHTS, key_prefix=key_prefix)
