import django
import os.path
import re

def get_svn_revision(path=None):
    """
    Returns the SVN revision in the form SVN-XXXX,
    where XXXX is the revision number.

    Returns SVN-unknown if anything goes wrong, such as an unexpected
    format of internal SVN files.

    If path is provided, it should be a directory whose SVN info you want to
    inspect. If it's not provided, this will use the root django/ package
    directory.
    """
    rev = None
    if path is None:
        path = django.__path__[0]
    entries_path = '%s/.svn/entries' % path

    if not os.environ['SERVER_SOFTWARE'].startswith('Dev'):
      if os.path.exists(entries_path):
          entries = open(entries_path, 'r').read()
          # Versions >= 7 of the entries file are flat text.  The first line is
          # the version number. The next set of digits after 'dir' is the revision.
          if re.match('(\d+)', entries):
              rev_match = re.search('\d+\s+dir\s+(\d+)', entries)
              if rev_match:
                  rev = rev_match.groups()[0]
          # Older XML versions of the file specify revision as an attribute of
          # the first entries node.
          else:
              from xml.dom import minidom
              dom = minidom.parse(entries_path)
              rev = dom.getElementsByTagName('entry')[0].getAttribute('revision')

    if rev:
        return u'SVN-%s' % rev
    return u'SVN-unknown'
