#!/usr/bin/python2.5
#
# Copyright 2008 the Melange authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Module that constructs the sitemap.
"""

__authors__ = [
    '"Sverre Rabbelier" <sverre@rabbelier.nl>',
  ]


from django.conf.urls import defaults

from soc.views.models import document
from soc.views.models import presence
from soc.views.models import host
from soc.views.models import request
from soc.views.models import user
from soc.views.models import site
from soc.views.models import sponsor

from soc.views.sitemap import sidebar
from soc.views.sitemap import sitemap


sidebar.addMenu(user.view.getUserSidebar)
sidebar.addMenu(presence.view.getSidebarLinks)
sidebar.addMenu(site.view.getSidebarLinks)
sidebar.addMenu(user.view.getSidebarLinks)
sidebar.addMenu(document.view.getSidebarLinks)
sidebar.addMenu(sponsor.view.getSidebarLinks)
sidebar.addMenu(host.view.getSidebarLinks)
sidebar.addMenu(request.view.getSidebarLinks)

sitemap.addPages(presence.view.getDjangoURLPatterns())
sitemap.addPages(site.view.getDjangoURLPatterns())
sitemap.addPages(user.view.getDjangoURLPatterns())
sitemap.addPages(document.view.getDjangoURLPatterns())
sitemap.addPages(sponsor.view.getDjangoURLPatterns())
sitemap.addPages(host.view.getDjangoURLPatterns())
sitemap.addPages(request.view.getDjangoURLPatterns())


def getPatterns():
  return defaults.patterns(None, *sitemap.SITEMAP)
