#!/usr/bin/python2.5
#
# Copyright 2008 the Melange authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Set of known *current* country and territory names.

Legacy (duplicate) names for some countries have been removed from the
original list.  Also missing are the following U.S. OFAC embargoed and
Commerce Department export-controlled countries:

  Cuba, Iran, Myanmar (formerly Burma), North Korea, Sudan, Syria
"""

__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
  '"Todd Larsen" <tlarsen@google.com>',
]


COUNTRIES_AND_TERRITORIES = (
  'Afghanistan, Islamic State of',
  'Albania',
  'Algeria',
  'American Samoa',
  'Andorra, Principality of',
  'Angola',
  'Anguilla',
  'Antarctica',
  'Antigua and Barbuda',
  'Argentina',
  'Armenia',
  'Aruba',
  'Australia',
  'Austria',
  'Azerbaidjan',
  'Bahamas',
  'Bahrain',
  'Bangladesh',
  'Barbados',
  'Belarus',
  'Belgium',
  'Belize',
  'Benin',
  'Bermuda',
  'Bhutan',
  'Bolivia',
  'Bosnia-Herzegovina',
  'Botswana',
  'Bouvet Island',
  'Brazil',
  'British Indian Ocean Territory',
  'Brunei Darussalam',
  'Bulgaria',
  'Burkina Faso',
  'Burundi',
  'Cambodia, Kingdom of',
  'Cameroon',
  'Canada',
  'Cape Verde',
  'Cayman Islands',
  'Central African Republic',
  'Chad',
  'Chile',
  'China',
  'Christmas Island',
  'Cocos (Keeling) Islands',
  'Colombia',
  'Comoros',
  'Congo',
  'Congo, Democratic Republic of the',
  'Cook Islands',
  'Costa Rica',
  'Croatia',
  'Cyprus',
  'Czech Republic',
  'Denmark',
  'Djibouti',
  'Dominica',
  'Dominican Republic',
  'East Timor',
  'Ecuador',
  'Egypt',
  'El Salvador',
  'Equatorial Guinea',
  'Eritrea',
  'Estonia',
  'Ethiopia',
  'Falkland Islands',
  'Faroe Islands',
  'Fiji',
  'Finland',
  'France',
  'French Guyana',
  'French Southern Territories',
  'Gabon',
  'Gambia',
  'Georgia',
  'Germany',
  'Ghana',
  'Gibraltar',
  'Greece',
  'Greenland',
  'Grenada',
  'Guadeloupe (French)',
  'Guam (USA)',
  'Guatemala',
  'Guinea',
  'Guinea Bissau',
  'Guyana',
  'Haiti',
  'Heard and McDonald Islands',
  'Holy See (Vatican City State)',
  'Honduras',
  'Hong Kong',
  'Hungary',
  'Iceland',
  'India',
  'Indonesia',
  'Iraq',
  'Ireland',
  'Israel',
  'Italy',
  "Ivory Coast (Cote D'Ivoire)",
  'Jamaica',
  'Japan',
  'Jordan',
  'Kazakhstan',
  'Kenya',
  'Kiribati',
  'Kuwait',
  'Kyrgyz Republic (Kyrgyzstan)',
  'Laos',
  'Latvia',
  'Lebanon',
  'Lesotho',
  'Liberia',
  'Libya',
  'Liechtenstein',
  'Lithuania',
  'Luxembourg',
  'Macau',
  'Macedonia',
  'Madagascar',
  'Malawi',
  'Malaysia',
  'Maldives',
  'Mali',
  'Malta',
  'Marshall Islands',
  'Martinique (French)',
  'Mauritania',
  'Mauritius',
  'Mayotte',
  'Mexico',
  'Micronesia',
  'Moldavia',
  'Monaco',
  'Mongolia',
  'Montenegro',
  'Montserrat',
  'Morocco',
  'Mozambique',
  'Namibia',
  'Nauru',
  'Nepal',
  'Netherlands',
  'Netherlands Antilles',
  'New Caledonia (French)',
  'New Zealand',
  'Nicaragua',
  'Niger',
  'Nigeria',
  'Niue',
  'Northern Mariana Islands',
  'Norway',
  'Oman',
  'Pakistan',
  'Palau',
  'Palestinian Territories',
  'Panama',
  'Papua New Guinea',
  'Paraguay',
  'Peru',
  'Philippines',
  'Pitcairn Island',
  'Poland',
  'Polynesia (French)',
  'Portugal',
  'Puerto Rico',
  'Qatar',
  'Reunion (French)',
  'Romania',
  'Russian Federation',
  'Rwanda',
  'South Georgia & South Sandwich Islands',
  'Saint Helena',
  'Saint Kitts & Nevis Anguilla',
  'Saint Lucia',
  'Saint Pierre and Miquelon',
  'Saint Tome (Sao Tome) and Principe',
  'Saint Vincent & Grenadines',
  'Samoa',
  'San Marino',
  'Saudi Arabia',
  'Senegal',
  'Serbia',
  'Seychelles',
  'Sierra Leone',
  'Singapore',
  'Slovak Republic',
  'Slovenia',
  'Solomon Islands',
  'Somalia',
  'South Africa',
  'South Korea',
  'Spain',
  'Sri Lanka',
  'Suriname',
  'Svalbard and Jan Mayen Islands',
  'Swaziland',
  'Sweden',
  'Switzerland',
  'Tadjikistan',
  'Taiwan',
  'Tanzania',
  'Thailand',
  'Togo',
  'Tokelau',
  'Tonga',
  'Trinidad and Tobago',
  'Tunisia',
  'Turkey',
  'Turkmenistan',
  'Turks and Caicos Islands',
  'Tuvalu',
  'USA Minor Outlying Islands',
  'Uganda',
  'Ukraine',
  'United Arab Emirates',
  'United Kingdom',
  'United States',
  'Uruguay',
  'Uzbekistan',
  'Vanuatu',
  'Venezuela',
  'Vietnam',
  'Virgin Islands (British)',
  'Virgin Islands (USA)',
  'Wallis and Futuna Islands',
  'Western Sahara',
  'Yemen',
  'Zambia',
  'Zimbabwe',
)

# mapping of countries to their CCTLD
COUNTRIES_TO_CCTLD = {
  'Afghanistan, Islamic State of': '.af',
  'Albania': '.al',
  'Algeria': '.dz',
  'American Samoa': '.as',
  'Andorra, Principality of': '.ad',
  'Angola': '.ao',
  'Anguilla': '.ai',
  'Antarctica': '.aq',
  'Antigua and Barbuda': '.ag',
  'Argentina': '.ar',
  'Armenia': '.am',
  'Aruba': '.aw',
  'Australia': '.au',
  'Austria': '.at',
  'Azerbaidjan': '.az',
  'Bahamas': '.bs',
  'Bahrain': '.bh',
  'Bangladesh': '.bd',
  'Barbados': '.bb',
  'Belarus': '.by',
  'Belgium': '.be',
  'Belize': '.bz',
  'Benin': '.bj',
  'Bermuda': '.bm',
  'Bhutan': '.bt',
  'Bolivia': '.bo',
  'Bosnia-Herzegovina': '.ba',
  'Botswana': '.bw',
  'Bouvet Island': '.bv',
  'Brazil': '.br',
  'British Indian Ocean Territory': '.io',
  'Brunei Darussalam': '.bn',
  'Bulgaria': '',
  'Burkina Faso': '.bg',
  'Burundi': '.bi',
  'Cambodia, Kingdom of': '.kh',
  'Cameroon': '.cm',
  'Canada': '.ca',
  'Cape Verde': '.cv',
  'Cayman Islands': '.ky',
  'Central African Republic': '.cf',
  'Chad': '.td',
  'Chile': '.cl',
  'China': '.cn',
  'Christmas Island': '.cx',
  'Cocos (Keeling) Islands': '.cc',
  'Colombia': '.co',
  'Comoros': '.km',
  'Congo': '.cg',
  'Congo, Democratic Republic of the': '.cd',
  'Cook Islands': '.ck',
  'Costa Rica': '.cr',
  'Croatia': '.hr',
  'Cyprus': '.cy',
  'Czech Republic': '.cz',
  'Denmark': '.dk',
  'Djibouti': '.dj',
  'Dominica': '.dm',
  'Dominican Republic': '.do',
  'East Timor': '.tl',
  'Ecuador': '.ec',
  'Egypt': '.eg',
  'El Salvador': '.sv',
  'Equatorial Guinea': '.gq',
  'Eritrea': '.er',
  'Estonia': '.ee',
  'Ethiopia': '.et',
  'Falkland Islands': '.fk',
  'Faroe Islands': '.fo',
  'Fiji': '.fj',
  'Finland': '.fi',
  'France': '.fr',
  'French Guyana': '.gf',
  'French Southern Territories': '.tf',
  'Gabon': '.ga',
  'Gambia': '.gm',
  'Georgia': '.ge',
  'Germany': '.de',
  'Ghana': '.gh',
  'Gibraltar': '.gi',
  'Greece': '.gr',
  'Greenland': '.gl',
  'Grenada': '.gd',
  'Guadeloupe (French)': '.gp',
  'Guam (USA)': '.gu',
  'Guatemala': '.gt',
  'Guinea': '.gn',
  'Guinea Bissau': '.gw',
  'Guyana': '.gy',
  'Haiti': '.ht',
  'Heard and McDonald Islands': '.hm',
  'Holy See (Vatican City State)': '.va',
  'Honduras': '.hn',
  'Hong Kong': '.hk',
  'Hungary': '.hu',
  'Iceland': '.is',
  'India': '.in',
  'Indonesia': '.id',
  'Iraq': '.iq',
  'Ireland': '.ie',
  'Israel': '.il',
  'Italy': '.it',
  "Ivory Coast (Cote D'Ivoire)": '.ci',
  'Jamaica': '.jm',
  'Japan': '.jp',
  'Jordan': '.jo',
  'Kazakhstan': '.kz',
  'Kenya': '.ke',
  'Kiribati': '.ki',
  'Kuwait': '.kw',
  'Kyrgyz Republic (Kyrgyzstan)': '.kg',
  'Laos': '.la',
  'Latvia': '.lv',
  'Lebanon': '.lb',
  'Lesotho': '.ls',
  'Liberia': '.lr',
  'Libya': '.ly',
  'Liechtenstein': '.li',
  'Lithuania': '.lt',
  'Luxembourg': '.lu',
  'Macau': '.mo',
  'Macedonia': '.mk',
  'Madagascar': '.mg',
  'Malawi': '.mw',
  'Malaysia': '.my',
  'Maldives': '.mv',
  'Mali': '.ml',
  'Malta': '.mt',
  'Marshall Islands': '.mh',
  'Martinique (French)': '.mq',
  'Mauritania': '.mr',
  'Mauritius': '.mu',
  'Mayotte': '.yt',
  'Mexico': '.mx',
  'Micronesia': '.fm',
  'Moldavia': '.md',
  'Monaco': '.mc',
  'Mongolia': '.mn',
  'Montenegro': '.me',
  'Montserrat': '.ms',
  'Morocco': '.ma',
  'Mozambique': '.mz',
  'Namibia': '.na',
  'Nauru': '.nr',
  'Nepal': '.np',
  'Netherlands': '.nl',
  'Netherlands Antilles': '.an',
  'New Caledonia (French)': '.nc',
  'New Zealand': '.nz',
  'Nicaragua': '.ni',
  'Niger': '.ne',
  'Nigeria': '.ng',
  'Niue': '.nu',
  'Northern Mariana Islands': '.mp',
  'Norway': '.no',
  'Oman': '.om',
  'Pakistan': '.pk',
  'Palau': '.pw',
  'Palestinian Territories': '.ps',
  'Panama': '.pa',
  'Papua New Guinea': '.pg',
  'Paraguay': '.py',
  'Peru': '.pe',
  'Philippines': '.ph',
  'Pitcairn Island': '.pn',
  'Poland': '.pl',
  'Polynesia (French)': '.pf',
  'Portugal': '.pt',
  'Puerto Rico': '.pr',
  'Qatar': '.qa',
  'Reunion (French)': '.re',
  'Romania': '.ro',
  'Russian Federation': '.ru',
  'Rwanda': '.rw',
  'South Georgia & South Sandwich Islands': '.gs',
  'Saint Helena': '.sh',
  'Saint Kitts & Nevis Anguilla': '.kn',
  'Saint Lucia': '.lc',
  'Saint Pierre and Miquelon': '.pm',
  'Saint Tome (Sao Tome) and Principe': '.st',
  'Saint Vincent & Grenadines': '.vc',
  'Samoa': '.ws',
  'San Marino': '.sm',
  'Saudi Arabia': '.sa',
  'Senegal': '.sn',
  'Serbia': '.rs',
  'Seychelles': '.sc',
  'Sierra Leone': '.sl',
  'Singapore': '.sg',
  'Slovak Republic': '.sk',
  'Slovenia': '.si',
  'Solomon Islands': '.sb',
  'Somalia': '.so',
  'South Africa': '.za',
  'South Korea': '.kr',
  'Spain': '.es',
  'Sri Lanka': '.lk',
  'Suriname': '.sr',
  'Svalbard and Jan Mayen Islands': '.sj',
  'Swaziland': '.sz',
  'Sweden': '.se',
  'Switzerland': '.ch',
  'Tadjikistan': '.tj',
  'Taiwan': '.tw',
  'Tanzania': '.tz',
  'Thailand': '.th',
  'Togo': '.tg',
  'Tokelau': '.tk',
  'Tonga': '.to',
  'Trinidad and Tobago': '.tt',
  'Tunisia': '.tn',
  'Turkey': '.tr',
  'Turkmenistan': '.tm',
  'Turks and Caicos Islands': '.tc',
  'Tuvalu': '.tv',
  'USA Minor Outlying Islands': '.um',
  'Uganda': '.ug',
  'Ukraine': '.ua',
  'United Arab Emirates': '.ae',
  'United Kingdom': '.uk',
  'United States': '.us',
  'Uruguay': '.uy',
  'Uzbekistan': '.uz',
  'Vanuatu': '.vu',
  'Venezuela': '.ve',
  'Vietnam': '.vn',
  'Virgin Islands (British)': '.vg',
  'Virgin Islands (USA)': '.vi',
  'Wallis and Futuna Islands': '.wf',
  'Western Sahara': '.eh',
  'Yemen': '.ye',
  'Zambia': '.zm',
  'Zimbabwe': '.zw',
}
