from django.db import models
from django.contrib.auth.models import User

from offline.event.models import Event

class Profile(models.Model):

    user = models.ForeignKey(User)
    profession = models.CharField(max_length=20,help_text="(Ex: Faculty, Student etc.)")
    affiliated_to = models.CharField(max_length=100, verbose_name="College/Company")

class QuestionBank(models.Model):
    """ A model for holding the database of questions.
    """

    quiz_num = models.CharField(max_length=2)

    description = models.TextField()
    code = models.TextField()
    options = models.TextField()
    time_limit = models.PositiveSmallIntegerField()
    expected_ans = models.TextField()

class Answer(models.Model):
    """ A model for holding answers submitted by users.
    """

    question = models.ForeignKey(QuestionBank)
    submitted_ans = models.TextField()
    is_correct = models.BooleanField()

class Quiz(models.Model):
    """ A model to hold the proceeding of a quiz.
    """

    user = models.ForeignKey(User)
    event = models.ForeignKey(Event)
    user_ip = models.CharField(max_length=15)
    key = models.CharField(max_length=10)
    
    quiz_num = models.CharField(max_length=2)
    que_remaining = models.CharField(max_length=100)
    que_answered = models.ManyToManyField(Answer)

