from xml.dom.minidom import parse, Node

from django.core.management.base import NoArgsCommand

from offline.quiz.models import QuestionBank, Quiz, TOPIC_CHOICES

topic_name2num = dict( [ (_[1], _[0]) for _ in TOPIC_CHOICES ] )

def seed_que():
    for question in QuestionBank.objects.all():
        question.delete()

    q_bank = parse("question_bank.xml").getElementsByTagName("question")

    for question in q_bank:

        topic_name_node = question.getElementsByTagName("topic")[0]
        topic_name = (topic_name_node.childNodes[0].data).strip()
        topic = topic_name2num[topic_name]

        description_node = question.getElementsByTagName("description")[0]
        description = (description_node.childNodes[0].data).strip()

        time_limit_node = question.getElementsByTagName("time_limit")[0]
        time_limit = time_limit_node.childNodes[0].data

        options_nodes = question.getElementsByTagName("options")
        options = (options_nodes[0].childNodes[0].data).strip() if options_nodes else ""

        code_nodes = question.getElementsByTagName("code")
        code = (code_nodes[0].childNodes[0].data).strip() if code_nodes else ""

        expected_ans_node = question.getElementsByTagName("expected_answer")[0]
        expected_ans = (expected_ans_node.childNodes[0].data).strip()

        new_question = QuestionBank(topic = topic,
                                    description = description, 
                                    time_limit = time_limit,
                                    options = options,
                                    code = code,
                                    expected_ans = expected_ans,
                                   )
        new_question.save()
    
class Command(NoArgsCommand):
    
    def handle_noargs(self, **options):
        """ Just copied the code from seed_db.py """
        
        seed_que()
