""" A collection of utilities for feedback app.
"""

from offline.feedback.models import *

LONG_FIELD_NAME = {'topics': "Range of topics covered:",
                   'depth': "Depth of coverage:",
                   'methodology': "Effectiveness of methodology:",
                   'pace': "Pace of coverage:",
                   'applicability': "Applicability:",
                   'problems': "Choice of problems:",
                   'exercises': "Choice of Exercises:",
                  }

EXPAND_OPTION = {
    "topics" : {
        "1" : "%d out of %s people felt that the range of topics covered was very relevant",
        "2" : "%d out of %s people felt that the range of topics covered was relevant",
        "3" : "%d out of %s people felt that the range of topics covered was somewhat relevant",
        "4" : "%d out of %s people felt that the range of topics covered was not relevant",
    },

    "depth" : {
        "1" : "%d out of %s people felt that the depth of coverage was too detailed",
        "2" : "%d out of %s people felt that the depth of coverage was detailed",
        "3" : "%d out of %s people felt that the depth of coverage was not detailed enough",
        "4" : "%d out of %s people felt that the depth of coverage was poorly detailed",
    },

    "methodology" : {
        "1" : "%d out of %s people felt that the teaching methodology was extremely effective",
        "2" : "%d out of %s people felt that the teaching methodology was effective",
        "3" : "%d out of %s people felt that the teaching methodology was not very effective",
        "4" : "%d out of %s people felt that the teaching methodology was ineffective",
    },

    "pace" : {
        "1" : "%d out of %s people felt that the the pace of coverage was too fast",
        "2" : "%d out of %s people felt that the the pace of coverage was fast",
        "3" : "%d out of %s people felt that the the pace of coverage was just right",
        "4" : "%d out of %s people felt that the the pace of coverage was slow",
        "5" : "%d out of %s people felt that the the pace of coverage was too slow",
    },

    "applicability" : {
        "1" : "%d out of %s people felt that they can apply what they have learnt immediately",
        "2" : "%d out of %s people felt that they can apply what they have learnt somewhat immediately",
        "3" : "%d out of %s people felt that they cannot apply what they have learnt immediately",
        "4" : "%d out of %s people felt that they might never apply what they have learnt",
    },

    "problems" : {
        "1" : "%d out of %s people felt that the problems were very interesting",
        "2" : "%d out of %s people felt that the problems were interesting",
        "3" : "%d out of %s people felt that the problems were somewhat interesting",
        "4" : "%d out of %s people felt that the problems were not interesting",
    },

    "exercises" : {
        "1" : "%d out of %s people felt that the exercises were very instructive",
        "2" : "%d out of %s people felt that the exercises were instructive",
        "3" : "%d out of %s people felt that the exercises were somewhat instructive",
        "4" : "%d out of %s people felt that the exercises were not instructive",
    },
}

def make_day_report(feeds):
    """ take a list of feedback objects and return the percentage of each item in the form of a dict.
    """

    no_of_feeds = feeds.count()
    if not no_of_feeds:
        return []

    day_report = []

    for field in ['topics', 'depth', 'methodology', 'pace', 'applicability', 'problems', 'exercises']:
        
        choices = eval((field+'_choices').upper()) ## the choices are named accordingly in the models file
        choices_dict = dict(choices)
        
        field_report = []
        for option in sorted(choices_dict.keys()):
            args_dict = {field : option}
            option_percent = feeds.filter(**args_dict).count() * 100.0 / no_of_feeds
            option_feeds = feeds.filter(**args_dict).count()
            if option_feeds:
                field_report.append((EXPAND_OPTION[field][option])%(option_feeds,no_of_feeds))
        
        if field_report:
            day_report.extend( [LONG_FIELD_NAME[field], field_report] )

    return day_report
        
    
