from django.shortcuts import render_to_response
from django.http import Http404

from offline.event.models import Event

from offline.feedback.models import Feedback
from offline.feedback.forms import FeedbackForm


def submit_feedback(request):

    """ see if the ip address has already submitted a feedback.
    if not, collect the feedback.
    """

    try:
        event = Event.objects.all()[0]
    except IndexError:
        raise Http404

    if event.feedback_status == "0":
        raise Http404
    else:
        day = event.feedback_status

    ip = request.META['REMOTE_ADDR']

    try:
        Feedback.objects.get(event=event,day=day,user_ip=ip)
        return render_to_response('submit_feedback.html', {'submitted':True, 'event':event})
    except Feedback.DoesNotExist:
        new_feedback = Feedback(event=event,day=day,user_ip=ip)
       
    if request.method == "POST":
        form = FeedbackForm(request.POST)
        if form.is_valid():
            data = form.cleaned_data
            new_feedback.topics = data['topics']  
            new_feedback.depth = data['depth']
            new_feedback.methodology = data['methodology']
            new_feedback.pace = data['pace']
            new_feedback.applicability = data['applicability']
            new_feedback.problems = data['problems']
            new_feedback.exercises = data['exercises']
            new_feedback.comments = data['comments']
            new_feedback.save()

            return render_to_response('submit_feedback.html', {'submitted':True, 'event':event})
        else:
            return render_to_response('submit_feedback.html',{ 'form':form, 'event':event})
    else:
        form = FeedbackForm()
        return render_to_response('submit_feedback.html',{'form':form, 'event':event})

def open_feedback():
    pass

def close_feedback():
    pass

