from django.conf.urls.defaults import *

from offline.feedback import views as feed_views
from offline.event import views as event_views
from offline.quiz import views as quiz_views

from offline.settings import ADMIN_KEY as AK

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = patterns('',
    # Example:
    # (r'^offline/', include('offline.foo.urls')),

    # Uncomment the admin/doc line below and add 'django.contrib.admindocs' 
    # to INSTALLED_APPS to enable admin documentation:
    # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    # (r'^admin/', include(admin.site.urls)),

    (r'^$', event_views.event_home),
    (r'^event/admin/%s$'%AK, event_views.event_admin),
    (r'^event/create/%s$'%AK, event_views.event_create),

    (r'^feedback/submit$', feed_views.submit_feedback),
    (r'^feedback/open/%s$'%AK, feed_views.open_feedback),
    (r'^feedback/close/%s$'%AK, feed_views.close_feedback),
    (r'^feedback/list/%s$'%AK, feed_views.list_feedbacks),
    (r'^feedback/report/%s$'%AK, feed_views.view_report),

    (r'^quiz/questions/list/%s$'%AK, event_views.list_questions),
    (r'^quiz/questions/edit/%s/(\w+)$'%AK, event_views.edit_question),

    (r'^quiz/open/%s$'%AK, event_views.open_quiz),
    (r'^quiz/close/%s$'%AK, event_views.close_quiz),
    (r'^quiz$', quiz_views.start_page),
    (r'^quiz/intro/(\w+)$', quiz_views.quiz_intro),
    (r'^quiz/start/$', quiz_views.start_quiz),
    (r'^quiz/answer/(\w+)$', quiz_views.answer),
    (r'^quiz/complete/$', quiz_views.quiz_complete),

    (r'^quiz/toppers/%s/(\w+)$'%AK, event_views.list_toppers),
    (r'^quiz/user_dump/%s/(\w+)/(\w+)$'%AK, event_views.user_dump),
    (r'^quiz/que_dump/%s/(\w+)$'%AK, event_views.que_dump),
)
