from django import forms

from offline.feedback.models import Feedback

class FeedbackForm(forms.ModelForm):
    """ A form to collect the feedback.
    """

    class Meta:
        model = Feedback
        exclude = [ 'event', 'day', 'user_ip']

    def clean_comments(self):
        comments = self.cleaned_data['comments']
        return comments.strip()
