import sys
from datetime import datetime

from django.core.management.base import NoArgsCommand

from offline.event.models import Event
from offline.quiz.models import QuestionBank

def seed_db():
    ev = Event()
    ev.title = "Some Workshop"
    ev.start_date = datetime.now()
    ev.stop_date = datetime.now()
    ev.quiz_status = '11'
    ev.save()

    q1 = QuestionBank()
    q1.quiz_num = "11"
    q1.description = "How do you combine two lists a and b"
    q1.type = 'S'
    q1.time_limit = 15
    q1.expected_ans = r"a + b"
    q1.save()

    q2 = QuestionBank()
    q2.quiz_num = '11'
    q2.description = "What IPython magic command would you use to obtain the code that you have already typed."
    q2.type = "S"
    q2.time_limit = 15
    q2.expected_ans = r"%hist"
    q2.save()

    q3 = QuestionBank()
    q3.quiz_num = "11"
    q3.description = "a = [1, 2, 5, 9]. How do you add 10 to end of this list."
    q3.type = "S"
    q3.time_limit = 30
    q3.expected_ans = r"a.append(10)"
    q3.save()

    
class Command(NoArgsCommand):
    
    def handle_noargs(self, **options):
        """ Just copied the code from seed_db.py """
        
        seed_db()
