from django import forms

from offline.event.models import Event, QUIZ_CHOICES
from offline.quiz.models import TOPICS_CHOICES

class EventCreateForm(forms.ModelForm):

    class Meta:
        model = Event
        fields = ['title', 'start_date', 'stop_date']

    def clean_start_date(self):
        return self.cleaned_data['start_date']

    def clean_stop_date(self):

        stop_date = self.cleaned_data['stop_date']
        start_date = self.clean_start_date()

        if start_date > stop_date:
            raise forms.ValidationError("Event cannot stop before it starts")

        return self.cleaned_data['stop_date']

class OpenQuizForm(forms.Form):

    quiz_num = forms.ChoiceField(required=True, widget=forms.RadioSelect, choices=QUIZ_CHOICES)
    topics = forms.MultipleChoiceField(required=True, widget=forms.CheckboxSelectMultiple, choices=TOPIC_CHOICES,)
    
    def clean_topics(self):

        return self.cleaned_data["topics"]
