from django.db import models


QUIZ_CHOICES = (("11", "Day 1 Quiz 1"),
                ("12", "Day 1 Quiz 2"),
                ("21", "Day 2 Quiz 1"),
               )

class Event(models.Model):
    """ An event.
    """

    title = models.CharField(max_length=200)
    start_date = models.DateField()
    stop_date = models.DateField()
    feedback_status = models.CharField(max_length=1, default='0')
    quiz_status = models.CharField(max_length=2, default='00', verbose_name="Quiz Name", choices=QUIZ_CHOICES)
