from django.http import Http404
from django.shortcuts import render_to_response, redirect

from offline.settings import ADMIN_KEY

from offline.event.models import Event
from offline.event.forms import EventCreateForm

from offline.quiz.utils import correct_quiz

num2name = {"11" : "Day 1 Quiz 1",
            "12" : "Day 1 Quiz 2",
            "21" : "Day 2 Quiz 1",
           }

def event_home(request):
    """ The page for people to view.
    """

    try:
        event = Event.objects.all()[0]
    except IndexError:
        raise Http404

    ip = request.META['REMOTE_ADDR']

    can_submit_feedback = True if event.feedback_status != '0' and \
            not event.feedback.filter(day=event.feedback_status,user_ip=ip) else False
    can_take_quiz = True if event.quiz_status != "00" else False

    return render_to_response('home.html', {'event':event, 'can_submit_feedback':can_submit_feedback, 'can_take_quiz':can_take_quiz})

def event_admin(request, admin_key):
    """ see if the key is correct and then display options.
    """

    if not admin_key == ADMIN_KEY:
        raise Http404

    try:
        event = Event.objects.all()[0]
    except IndexError:
        return redirect('/event/create/%s'%ADMIN_KEY)

    return render_to_response('admin.html', {'event':event, 'admin_key':ADMIN_KEY})
    
def event_create(request, admin_key):

    if not admin_key == ADMIN_KEY:
        raise Http404

    try:
        event = Event.objects.all()[0]
        return redirect("/event/admin/%s"%admin_key)
    except IndexError:
        new_event = Event()

    if request.method == "POST":
        form = EventCreateForm(request.POST)
        if form.is_valid():
            new_event.title = form.cleaned_data['title']
            new_event.start_date = form.cleaned_data['start_date']
            new_event.stop_date = form.cleaned_data['stop_date']

            new_event.save()
            return redirect('/event/admin/%s'%ADMIN_KEY)
        else:
            return render_to_response('create_event.html',{'form':form})
    else:
        form = EventCreateForm()
        return render_to_response('create_event.html',{'form':form})

def open_quiz(request, admin_key):
    """ check for admin and then for quiz status.
    """

    if not admin_key == ADMIN_KEY:
        raise Http404

    try:
        event = Event.objects.all()[0]
    except IndexError:
        return redirect('/event/create/%s'%ADMIN_KEY)

    if event.quiz_status != "00":
        return redirect('/event/create/%s'%ADMIN_KEY)

    if request.method=="POST":
        try:
            quiz_num = request.POST['quiz_num']
            event.quiz_status = quiz_num
            event.save()
            return render_to_response("open_quiz.html",{"admin_key":ADMIN_KEY, "quiz_name":num2name[quiz_num], 'success':True})
        except MultiValueDictKeyError:
            raise Http404
    else:
        return render_to_response("open_quiz.html")
   
def close_quiz(request, admin_key):
    """ check for admin and then for quiz status.
    """

    if not admin_key == ADMIN_KEY:
        raise Http404

    try:
        event = Event.objects.all()[0]
    except IndexError:
        return redirect('/event/create/%s'%ADMIN_KEY)

    if event.quiz_status == "00":
        return redirect('/event/create/%s'%ADMIN_KEY)
    
    quiz_num = event.quiz_status

    event.quiz_status = "00"
    event.save()

    event_quizzes = event.quiz.filter(quiz_num=quiz_num)
    for quiz in event_quizzes:
        correct_quiz(quiz)

    return render_to_response("close_quiz.html", {"admin_key":ADMIN_KEY, "quiz_name":num2name[quiz_num]})

