from django.http import Http404
from django.shortcuts import render_to_response

from offline.event.models import Event

def event_home(request):
    """ The page for people to view.
    """

    try:
        event = Event.objects.all()[0]
    except IndexError:
        raise Http404

    ip = request.META['REMOTE_ADDR']

    can_submit_feedback = True if event.feedback_status != '0' and \
            not event.feedback.filter(day=event.feedback_status,user_ip=ip) else False
    can_take_quiz = False

    return render_to_response('home.html', {'event':event, 'can_submit_feedback':can_submit_feedback, 'can_take_quiz':can_take_quiz})

