import string
import random
import re

def gen_key(no_of_chars):
    allowed_chars = string.digits+string.uppercase
    return ''.join([random.choice(allowed_chars) for i in range(no_of_chars)])

def correct_quiz(quiz):
    """ read each submitted answer and update the is_correct variable.
    """

    for answer in quiz.que_answered.all():

        expected_ans = answer.question.expected_ans

        ans_regex_patterns = []
        for ans_pattern in expected_ans.split("\n"):
            ans_regex_patterns.append( r"\s*".join(ans_pattern.split()) if not re.match(r"""^[",']""", ans_pattern) else ans_pattern )

        for pattern in ans_regex_patterns:
            if re.findall(pattern, answer.submitted_ans):
                answer.is_correct = True
                answer.save()
                break

