from django.db import models
from django.contrib.auth.models import User

from offline.event.models import Event

TOPIC_CHOICES = (("11", "Plotting"),
                 ("12", "Lists and Files"),
                 ("13", "Strings"),
                 ("14", "Dictionaries and Piecharts"),
                 ("15", "Statistics"),
                 ("16", "Matrices"),
                 ("17", "Solving linear equations"),
                 ("18", "Finding roots"),

                 ("21", "Basic Datatypes"),
                 ("22", "Input and Output"),
                 ("23", "Lists and Tuples"),
                 ("24", "Dictionaries"),
                 ("25", "Sets"),
                 ("26", "Conditional Statements"),
                 ("27", "Functions"),
                 )

class Profile(models.Model):
    """ A profile for quiz takers.
    """

    user = models.ForeignKey(User)
    profession = models.CharField(max_length=20,help_text="(Ex: Faculty, Student etc.)")
    affiliated_to = models.CharField(max_length=100, verbose_name="College/Company")

class QuestionBank(models.Model):
    """ A model for holding the database of questions.
    """

    quiz_num = models.CharField(max_length=2, default="00")
    topic = models.CharField(max_length=2,choices=TOPIC_CHOICES)

    description = models.TextField()
    code = models.TextField()
    options = models.TextField()
    time_limit = models.PositiveSmallIntegerField()
    expected_ans = models.TextField()

class Answer(models.Model):
    """ A model for holding answers submitted by users.
    """

    question = models.ForeignKey(QuestionBank, related_name="%(class)s")
    submitted_ans = models.TextField()
    is_correct = models.BooleanField(default=False)

class Quiz(models.Model):
    """ A model to hold the proceeding of a quiz.
    """

    user = models.ForeignKey(User)
    event = models.ForeignKey(Event, related_name="%(class)s")
    user_ip = models.CharField(max_length=15)
    key = models.CharField(max_length=10)
    
    quiz_num = models.CharField(max_length=2)
    que_remaining = models.CharField(max_length=100)
    que_answered = models.ManyToManyField(Answer, related_name="%(class)s")

