from django import forms

from offline.event.models import Event

class EventCreateForm(forms.ModelForm):

    class Meta:
        model = Event
        fields = ['title', 'start_date', 'stop_date']

    def clean_start_date(self):
        return self.cleaned_data['start_date']

    def clean_stop_date(self):

        stop_date = self.cleaned_data['stop_date']
        start_date = self.clean_start_date()

        if start_date > stop_date:
            raise forms.ValidationError("Event cannot stop before it starts")

        return self.cleaned_data['stop_date']

