"""A Django template tag library containing forms helpers.
"""

__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from django import template


register = template.Library()


@register.inclusion_tag('projrev/templatetags/_as_review.html')
def as_review(review):
  """Returns the comment contexts for the template tag.
  """

  total_score = (review.attribute1 + review.attribute2 + review.attribute3 + 
                 review.attribute4 + review.attribute5 + review.attribute6 +
                 review.attribute7 + review.attribute8 + review.attribute9)

  return {'review': review, 'total_score': total_score}

@register.inclusion_tag('projrev/templatetags/_as_my_review.html')
def as_my_review(review):
  """Returns the comment contexts for the template tag.
  """

  total_score = (review.attribute1 + review.attribute2 + review.attribute3 + 
                 review.attribute4 + review.attribute5 + review.attribute6 +
                 review.attribute7 + review.attribute8 + review.attribute9)

  project = review.project
  proposal = project.proposal_set.all().order_by('-submitted_on')[0]

  review_context = {
      'review': review,
      'total_score': total_score,
      }

  if proposal:
    proposal_path = str(proposal.document)
    proposal_name = proposal_path.split('/')[-1]
    review_context['proposal_path'] = proposal_path
    review_context['proposal_name'] = proposal_name
    review_context['institution'] = project.institution
    review_context['state'] = project.state
    review_context['district'] = project.district
    review_context['line_item'] = project.line_item

  return review_context

@register.inclusion_tag('projrev/templatetags/_as_star_for_score.html',
                         takes_context=True)
def as_star_for_score(context, name):
  """
  """
  context['name'] = name
  if 'prev_data' in context and name in context['prev_data']:
    context['value'] = str(context['prev_data'][name])
  else:
    context['value'] = 0
 
  return context

@register.filter()
def serial_no(project, arg):
  """Returns the latest serial number of the project's proposal
  """

  proposals = project.proposal_set.all().order_by('-submitted_on')

  if proposals:
    if arg == 'new':
      proposal = proposals[0]
    elif arg == 'old':
      if len(proposals) > 1:
        proposal = proposals[1]
      else:
        proposal = None

    if proposal:
      return str(proposal.id)

  return 'NA'

@register.filter()
def splitline(comment):
  """Split into a line
  """

  return str(comment.split('\n')[0])