"""Module to fetch data.
"""

__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


import json


def fetch_state_code(file_name):
  """Fetch State Codes
  """

  fh = file(file_name)
  states = {} 
  for line in fh:
    name, code = line.split('\t')
    name = name.strip()
    code = code.strip()
    states[code] = name
  print json.dumps(states, indent=4)

def fetch_district_code(file_name, write_file):
  """Fetch District Codes
  """

  fh = file(file_name)
  districts = {}
  for line in fh:
    if line == '\n' or line[:4] == 'See ' or line[:4] == 'Code':
      continue
    if line[:6] == '[edit]':
      state = line[6:].strip().split()[-1].strip('()')
      continue 
    district_line = line.split('\t')
    code = '%s%s' % (state, district_line[0].strip())
    name = district_line[1].strip()
    districts[code] = name
    if len(code) > 4:
      print code, name
  fh.close()
  district_data = json.dumps(districts, indent=6)
  fh = file(write_file, "w")
  fh.write(district_data)
  fh.close()

if __name__ == '__main__':
  import sys
  if sys.argv[1] == 'fetch_state_code':
    fetch_state_code(sys.argv[2])
  if sys.argv[1] == 'fetch_district_code':
    fetch_district_code(sys.argv[2], sys.argv[3])