from django.conf.urls.defaults import *
from django.conf import settings


# Uncomment the next two lines to enable the admin:
from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',
    # Example:
    # (r'^app/', include('app.foo.urls')),

    # Uncomment the admin/doc line below and add 'django.contrib.admindocs' 
    # to INSTALLED_APPS to enable admin documentation:
    #(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    (r'^admin/', include(admin.site.urls)),
    (r'^$', 'app.projrev.views.base.home'),
    (r'^login/$', 'app.projrev.views.login.login_validate'),
    (r'^create_account/$', 'app.projrev.views.login.create_account'),
    (r'^forgot_password/$', 'app.projrev.views.login.forgot_password'),
    (r'^logout/$', 'app.projrev.views.login.logout_view'),
    (r'^proposal/submit/$', 'app.projrev.views.proposal.getMicr'),
    (r'^proposal/submit/create/$', 'app.projrev.views.proposal.submit'),
    (r'^proposal/withdraw/(?P<micr_code>[A-Z]{6}\d{9})/$',
     'app.projrev.views.proposal.withdraw'),
    (r'^proposal/submit/(?P<micr_code>[A-Z]{6}\d{9})/$',
     'app.projrev.views.proposal.submit'),
    (r'^proposal/review/$', 'app.projrev.views.proposal.review'),
    (r'^proposal/review/(?P<micr_code>[A-Z]{6}\d{9})/$', 
     'app.projrev.views.proposal.review'),
    (r'^proposal/rank/$', 'app.projrev.views.proposal.rank'),
    (r'^proposal/rank/(?P<micr_code>[A-Z]{6}\d{9})/$',
     'app.projrev.views.proposal.rank'),
    (r'^site-content/(?P<path>.*)', 'django.views.static.serve',
        {'document_root': settings.MEDIA_ROOT}),

)
